/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.program_files;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.sosy_lab.verifiercloud.client.applications.webclient.git_handling.GitManager;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.BuildFailedException;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.ProgramFilesProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.ImmutableSvnRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevisionPattern;
import org.sosy_lab.verifiercloud.client.files.WebClientFileStorage;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.exceptions.FileNotAvailableOnTheMaster;
import org.sosy_lab.verifiercloud.client.network.exceptions.InsufficientRightsException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RunCanceledException;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionCreationException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.util.FileUtils;
import org.sosy_lab.verifiercloud.transportable.collections.DefaultRunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.RelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.DefaultFileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.StringRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.tree_based.TreeFileHierarchyBuilder;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunBuilder;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.LimitationsBuilder;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.Requirements;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.RequirementsBuilder;
import org.sosy_lab.verifiercloud.transportable.run.filters.DisjunctiveFileFilter;
import org.sosy_lab.verifiercloud.transportable.run.filters.FileFilter;
import org.sosy_lab.verifiercloud.transportable.run.filters.PatternFileFilter;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class EagerProgramFilesProvider
implements ProgramFilesProvider {
    private static final Joiner.MapJoiner RUN_INFORMATION_JOINER = Joiner.on('\n').withKeyValueSeparator(": ");
    private static final RelativePath OUTPUT_FILE = StringRelativePath.from("output.txt");
    private static final String REVISION_WILDCARD = "${revision}";
    private final AtomicBoolean initialiezed = new AtomicBoolean(false);
    private ExecutorService precomputationThreadPool;
    private final ImmutableSet<SvnRevisionPattern> allUsedRevisions;
    private final ImmutableSet<String> requieredFilePatterns;
    private final Optional<ImmutableList<String>> buildCommand;
    private final ImmutableSet<String> buildCommandRequieredFilePatterns;
    private final ImmutableSet<FileFilter> buildCommandResultFiles;
    private final Limitations buildCommandLimitation;
    private final Requirements buildCommandRequirements;
    private final SchedulingPriority buildCommandSchedulingPriority;
    private final WebClientFileStorage fileStorage;
    private final GitManager gitManager;
    private final MasterConnection masterConnection;
    private final Logger logger;
    private final LoadingCache<ImmutableSvnRevision, TreeFileHierarchyBuilder> programFiles;

    @Inject
    public EagerProgramFilesProvider(@Named(value="allowedRevisionsAndBranches") ImmutableSet<SvnRevisionPattern> allUsedRevisions, @Named(value="requiredFilePatterns") ImmutableSet<String> requieredFiles, @Named(value="buildCommand") Optional<ImmutableList<String>> buildCommand, @Named(value="buildCommandrequiredFilePatterns") ImmutableSet<String> buildCommandRequieredFiles, @Named(value="buildCommandResultFiles") ImmutableSet<String> buildCommandResultFiles, @Named(value="buildCommandTimeLimitation") TimeInterval buildRunTimeLimitation, @Named(value="buildCommandMemoryRequirementLimitation") MemoryUnit buildRunMemoryRequirementLimitation, @Named(value="buildCommandCoresLimitation") int buildRunCoresRequirementLimitation, @Named(value="buildCommandCpuModels") ImmutableList<String> buildCommandCpuModels, @Named(value="buildCommandSchedulingPriority") SchedulingPriority buildCommandSchedulingPriority, WebClientFileStorage clientFileStorage, MasterConnection masterConnection, GitManager gitManager, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Logger logger) {
        this.allUsedRevisions = Preconditions.checkNotNull(allUsedRevisions);
        this.requieredFilePatterns = Preconditions.checkNotNull(requieredFiles);
        this.buildCommand = Preconditions.checkNotNull(buildCommand);
        this.buildCommandRequieredFilePatterns = Preconditions.checkNotNull(buildCommandRequieredFiles);
        this.buildCommandResultFiles = FluentIterable.from(buildCommandResultFiles).transform(new StringToPatternFileFilterFunction()).toSet();
        this.buildCommandLimitation = LimitationsBuilder.from(buildRunTimeLimitation).setMemoryLimit(buildRunMemoryRequirementLimitation).setCoreLimit(buildRunCoresRequirementLimitation).build();
        this.buildCommandRequirements = RequirementsBuilder.withProcessors(buildRunCoresRequirementLimitation).setMemoryRequirements(buildRunMemoryRequirementLimitation).setCpuRequirements(buildCommandCpuModels).build();
        this.buildCommandSchedulingPriority = Preconditions.checkNotNull(buildCommandSchedulingPriority);
        this.fileStorage = Preconditions.checkNotNull(clientFileStorage);
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.gitManager = Preconditions.checkNotNull(gitManager);
        this.logger = Preconditions.checkNotNull(logger);
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(EagerProgramFilesProvider.class.getSimpleName() + "-Initializer-%d").setUncaughtExceptionHandler(uncaughtExceptionHandler);
        this.precomputationThreadPool = Executors.newFixedThreadPool(5, tfb.build());
        this.programFiles = CacheBuilder.newBuilder().softValues().maximumSize(20 + 20 * allUsedRevisions.size()).build(new CacheLoader<ImmutableSvnRevision, TreeFileHierarchyBuilder>(){

            @Override
            public TreeFileHierarchyBuilder load(ImmutableSvnRevision key) throws Exception {
                return EagerProgramFilesProvider.this.createFileHierarchyBuilder(key);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeFileHierarchyBuilder createFileHierarchyBuilder(ImmutableSvnRevision revision) throws GitAPIException, IOException, RunCollectionCreationException, InterruptedException, BuildFailedException {
        TreeFileHierarchyBuilder programFileHierarchyBuilder;
        this.logger.logf(Level.FINE, "Creating program file hierarchy for %s.", revision);
        CheckedFuture<RunResult, RunCanceledException> buildResultFuture = null;
        GitManager gitManager = this.gitManager;
        synchronized (gitManager) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Path toolBasePath = this.gitManager.checkOut(revision);
            if (this.buildCommand.isPresent()) {
                this.logger.logf(Level.FINER, "Creating build run for %s.", revision);
                buildResultFuture = this.startBuildRun(toolBasePath, revision);
            }
            programFileHierarchyBuilder = new TreeFileHierarchyBuilder();
            this.logger.logf(Level.FINER, "Hashing program files for %s.", revision);
            this.addFilesToFileHierachyBuilder(programFileHierarchyBuilder, this.requieredFilePatterns, toolBasePath);
        }
        if (this.buildCommand.isPresent()) {
            this.logger.logf(Level.FINER, "Waiting for build result of %s.", revision);
            this.addBuildResultFiles(buildResultFuture, programFileHierarchyBuilder);
        }
        this.logger.logf(Level.FINE, "Created file hierarchy for %s successfully.", revision);
        return programFileHierarchyBuilder;
    }

    private CheckedFuture<RunResult, RunCanceledException> startBuildRun(Path toolBasePath, ImmutableSvnRevision revision) throws IOException, RunCollectionCreationException {
        TreeFileHierarchyBuilder fileHierarchyBuilder = new TreeFileHierarchyBuilder();
        this.logger.logf(Level.FINER, "Hashing build files for %s.", revision);
        this.addFilesToFileHierachyBuilder(fileHierarchyBuilder, this.buildCommandRequieredFilePatterns, toolBasePath);
        DisjunctiveFileFilter resultFilePattern = new DisjunctiveFileFilter(this.buildCommandResultFiles);
        int revisionNumber = revision.getRevisionNumber();
        ImmutableList<String> buildCommandWithRevision = FluentIterable.from(this.buildCommand.get()).transform(new RevisionWildcardReplaceFunction(revisionNumber)).toList();
        Run buildRun = RunBuilder.forCommand(buildCommandWithRevision).addFiles(fileHierarchyBuilder.build()).setLimitations(this.buildCommandLimitation).setOutputFilePattern(resultFilePattern).setDescription("Webclient build run.").setWorkerResultFile(OUTPUT_FILE).build();
        RunCollection buildCommandRunCollection = DefaultRunCollection.forRuns(Lists.newArrayList(buildRun)).setInitialPriority(this.buildCommandSchedulingPriority).setRequirements(this.buildCommandRequirements).setName("Webclient build run.").build();
        this.logger.logf(Level.FINER, "Sending build command for %s.", revision);
        try {
            return this.masterConnection.sendRunCollection(buildCommandRunCollection, false).get(0);
        }
        catch (InsufficientRightsException e) {
            throw new RunCollectionCreationException(e);
        }
    }

    private void addFilesToFileHierachyBuilder(TreeFileHierarchyBuilder programFileHierarchyBuilder, ImmutableSet<String> requieredFilePatterns, Path toolBasePath) throws IOException, RunCollectionCreationException {
        for (String requieredPathPattern : requieredFilePatterns) {
            Iterable<Path> requieredPaths = this.expandPattern(requieredPathPattern, toolBasePath);
            if (FluentIterable.from(requieredPaths).isEmpty()) {
                throw new RunCollectionCreationException("No files for pattern " + requieredPathPattern + " found.");
            }
            for (Path requieredPath : requieredPaths) {
                List<Path> allRequieredFiles = FileUtils.recursiveFileList(requieredPath);
                for (Path requieredFile : allRequieredFiles) {
                    FileAtRelativePath fileAtRelativePath = this.getFileAtRelativePathFromPath(requieredFile, toolBasePath);
                    programFileHierarchyBuilder.addProgramFiles(fileAtRelativePath);
                }
            }
        }
    }

    private Iterable<Path> expandPattern(final String pathPattern, final Path basePath) throws IOException {
        final ArrayList<Path> result = Lists.newArrayList();
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + pathPattern);
        Files.walkFileTree(basePath, ImmutableSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path relativePath = basePath.relativize(dir);
                if (pathMatcher.matches(relativePath)) {
                    result.add(dir);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relativePath = basePath.relativize(file);
                if (pathMatcher.matches(relativePath)) {
                    result.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
                EagerProgramFilesProvider.this.logger.logf(Level.SEVERE, "Cannot expand %s at %s: %s ", pathPattern, file, e.getMessage());
                return FileVisitResult.TERMINATE;
            }
        });
        return result;
    }

    private void addBuildResultFiles(CheckedFuture<RunResult, RunCanceledException> buildResultFuture, TreeFileHierarchyBuilder programFileHierarchyBuilder) throws BuildFailedException {
        RunResult buildCommandRunResult;
        try {
            buildCommandRunResult = buildResultFuture.checkedGet();
        }
        catch (RunCanceledException e) {
            throw new BuildFailedException(e);
        }
        this.logger.logf(Level.FINE, "Received build result.", new Object[0]);
        if (buildCommandRunResult.wasKilled() || buildCommandRunResult.getExitCode() != 0) {
            this.buildFailed(buildCommandRunResult);
        }
        for (FileFilter requieredPath : this.buildCommandResultFiles) {
            boolean fileFound = false;
            for (FileAtRelativePath resultFile : buildCommandRunResult.getResultFiles()) {
                if (!requieredPath.isFileMatched(resultFile)) continue;
                programFileHierarchyBuilder.addProgramFiles(resultFile);
                fileFound = true;
                try {
                    FileContent resultFileContent = (FileContent)this.masterConnection.getResultFile(resultFile.getFileHash()).get();
                    this.fileStorage.pushFile(resultFileContent);
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new BuildFailedException(e);
                }
            }
            if (fileFound) continue;
            this.buildFailed(buildCommandRunResult);
        }
    }

    private void buildFailed(RunResult buildCommandRunResult) throws BuildFailedException {
        String output = "";
        for (FileAtRelativePath resultFile : buildCommandRunResult.getResultFiles()) {
            FileContent outputContent;
            if (!resultFile.getRelativePath().equals(OUTPUT_FILE)) continue;
            try {
                outputContent = this.masterConnection.getResultFile(resultFile.getFileHash()).checkedGet();
            }
            catch (FileNotAvailableOnTheMaster e) {
                throw new BuildFailedException(e);
            }
            output = outputContent.getContent();
            break;
        }
        throw new BuildFailedException("Build command failed:\nExit code: " + buildCommandRunResult.getExitCode() + "\n" + "Was killed by cloud: " + buildCommandRunResult.wasKilled() + "\n" + RUN_INFORMATION_JOINER.join(buildCommandRunResult.getRunInformation()) + "\n" + "Result files: " + buildCommandRunResult.getResultFiles() + "\n" + "Worker: " + buildCommandRunResult.getHostInformation().getHostname() + " \n" + buildCommandRunResult.getWarnings().getContent() + "\n\n" + output);
    }

    private FileAtRelativePath getFileAtRelativePathFromPath(Path path, Path baseDir) throws IOException {
        if (!Files.exists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
            throw new IOException("File " + path.toAbsolutePath() + " does not exist.");
        }
        HashCode fileHash = this.fileStorage.pushFile(path.toAbsolutePath().normalize());
        Path absolutePath = path.toAbsolutePath().normalize();
        Path absoluteBaseDir = baseDir.toAbsolutePath().normalize();
        Preconditions.checkState(absolutePath.startsWith(absoluteBaseDir), "%s should start with %s", absolutePath, absoluteBaseDir);
        String relativePath = absoluteBaseDir.relativize(absolutePath).toString();
        return new DefaultFileAtRelativePath(fileHash, relativePath);
    }

    @Override
    public void initialize() throws IOException, GitAPIException, PermanentStorageException {
        Preconditions.checkState(!this.initialiezed.getAndSet(true));
        this.gitManager.initilize();
        this.fileStorage.initialize();
        for (SvnRevisionPattern revisionPattern : this.allUsedRevisions) {
            SvnRevision revision = revisionPattern.getRevisionForPreComputing();
            this.precomputationThreadPool.submit(new ProgramFilesPreComputer(revision));
        }
        this.precomputationThreadPool.shutdown();
    }

    @Override
    public void cleanUp() {
        Preconditions.checkState(this.initialiezed.getAndSet(false));
        if (this.masterConnection.isConnected()) {
            this.precomputationThreadPool.shutdown();
        } else {
            this.precomputationThreadPool.shutdownNow();
        }
        try {
            this.precomputationThreadPool.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.precomputationThreadPool.shutdownNow();
        }
        this.gitManager.cleanUp();
        try {
            this.fileStorage.cleanup();
        }
        catch (IOException e) {
            this.logger.logf(Level.WARNING, "Cannot cleanup the filesorage: %s.", e.getMessage());
        }
    }

    @Override
    public TreeFileHierarchyBuilder getProgramFiles(SvnRevision revision) throws RunCollectionCreationException, RefNotFoundException {
        ImmutableSvnRevision immutableRevision;
        Preconditions.checkState(this.initialiezed.get());
        this.logger.logf(Level.FINE, "Getting program files for revision %s.", revision);
        try {
            immutableRevision = revision.getCurrentRevision(this.gitManager);
        }
        catch (IOException e) {
            throw new RunCollectionCreationException(e);
        }
        try {
            return this.programFiles.get(immutableRevision);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RunCollectionCreationException) {
                throw (RunCollectionCreationException)cause;
            }
            if (cause instanceof RefNotFoundException) {
                throw (RefNotFoundException)cause;
            }
            throw new RunCollectionCreationException(e);
        }
    }

    @VisibleForTesting
    protected long getCacheSize() {
        return this.programFiles.size();
    }

    private final class ProgramFilesPreComputer
    implements Runnable {
        private SvnRevision revision;

        public ProgramFilesPreComputer(SvnRevision revision) {
            this.revision = Preconditions.checkNotNull(revision);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImmutableSvnRevision immutableRevision;
            while (EagerProgramFilesProvider.this.buildCommand.isPresent() && !EagerProgramFilesProvider.this.masterConnection.isConnected()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            EagerProgramFilesProvider.this.logger.logf(Level.INFO, "Precomputing program files for revision %s.", this.revision);
            try {
                GitManager gitManager = EagerProgramFilesProvider.this.gitManager;
                synchronized (gitManager) {
                    immutableRevision = this.revision.getCurrentRevision(EagerProgramFilesProvider.this.gitManager);
                }
            }
            catch (IOException | RefNotFoundException e) {
                EagerProgramFilesProvider.this.logger.logf(Level.WARNING, e, "Could not precompute file hierachy for %s: %s", this.revision, e.getMessage());
                return;
            }
            try {
                EagerProgramFilesProvider.this.programFiles.get(immutableRevision);
            }
            catch (ExecutionException e) {
                Throwable cause = Throwables.getRootCause(e);
                if (cause instanceof InterruptedException) {
                    EagerProgramFilesProvider.this.logger.logf(Level.INFO, "File hierachy precomputing for revisions %s was interrrupted.", this.revision);
                }
                EagerProgramFilesProvider.this.logger.logf(Level.WARNING, e, "Could not precompute file hierachy for %s.", this.revision);
            }
        }
    }

    private static final class RevisionWildcardReplaceFunction
    implements Function<String, String> {
        private final int revision;

        public RevisionWildcardReplaceFunction(int revision) {
            this.revision = revision;
        }

        @Override
        @SuppressFBWarnings(value={"NP"})
        public String apply(String input) {
            return input.replace(EagerProgramFilesProvider.REVISION_WILDCARD, Integer.toString(this.revision));
        }
    }

    private static class StringToPatternFileFilterFunction
    implements Function<String, FileFilter> {
        private StringToPatternFileFilterFunction() {
        }

        @Override
        public FileFilter apply(String input) {
            return PatternFileFilter.forWildcardPattern(Preconditions.checkNotNull(input));
        }
    }
}

