/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.resources;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.glassfish.jersey.media.multipart.ContentDisposition;
import org.glassfish.jersey.server.mvc.Template;
import org.sosy_lab.verifiercloud.client.applications.webclient.api.WebClientAPI;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.DefaultStartRunInformation;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.form_format.FormArgumentFilesBean;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.form_format.FormRunConfiguration;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.multi_part_format.MultiPartArgumentFilesBean;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.multi_part_format.MultiPartRunConfiguration;
import org.sosy_lab.verifiercloud.client.network.exceptions.MasterSummaryNotRetrievableException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RequestFailureException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RunSubmissionFailureException;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionCreationException;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;

public class RunsResource {
    private static final String PREMIUM_PRIORITY_PATH = "premium_priority";
    public final WebClientAPI vCloud;
    public final String remoteAdress;
    private final String remoteUser;
    public final UriInfo uriInfo;

    @Inject
    public RunsResource(@Context HttpServletRequest request, @Context UriInfo uriInfo, WebClientAPI vCloud) {
        if (request != null) {
            this.remoteAdress = request.getRemoteAddr();
            String remoteUser = request.getRemoteUser();
            this.remoteUser = remoteUser == null ? "anonymousUser" : remoteUser;
        } else {
            this.remoteAdress = "unknown";
            this.remoteUser = "unknownUser";
        }
        this.uriInfo = Preconditions.checkNotNull(uriInfo);
        this.vCloud = Preconditions.checkNotNull(vCloud);
    }

    @GET
    @Produces(value={"text/html"})
    @Template(name="/runs")
    public Map<String, Object> getHTMLSubmissionPage(@Context UriInfo uriInfo) {
        this.logf("Received HTML submission page request.", new Object[0]);
        return this.vCloud.getModelGenerator().getRunsModel(uriInfo);
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String postRunFormFormat(@BeanParam FormRunConfiguration runConfiguration, @Valid @BeanParam FormArgumentFilesBean argumentFiles) throws RunSubmissionFailureException, RunCollectionCreationException, RefNotFoundException {
        DefaultStartRunInformation startRunInformation = new DefaultStartRunInformation(runConfiguration, argumentFiles, false);
        this.logf("Received submission request: %s", startRunInformation);
        return this.vCloud.startTool(startRunInformation).toString();
    }

    @POST
    @Produces(value={"text/html"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postRunFormFormatHTML(@BeanParam FormRunConfiguration runConfiguration, @Valid @BeanParam FormArgumentFilesBean argumentFiles) throws RunSubmissionFailureException, RunCollectionCreationException, RefNotFoundException {
        String id = this.postRunFormFormat(runConfiguration, argumentFiles);
        return Response.seeOther((URI)this.getRunStateURI(id)).build();
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"multipart/form-data"})
    public String postRunMultiPartFormat(@BeanParam MultiPartRunConfiguration runConfiguration, @Valid @BeanParam MultiPartArgumentFilesBean argumentFiles) throws RunSubmissionFailureException, RunCollectionCreationException, RefNotFoundException {
        DefaultStartRunInformation startRunInformation = new DefaultStartRunInformation(runConfiguration, argumentFiles, false);
        this.logf("Received submission request: %s", startRunInformation);
        return this.vCloud.startTool(startRunInformation).toString();
    }

    @POST
    @Produces(value={"text/html"})
    @Consumes(value={"multipart/form-data"})
    public Response postRunMultiPartFormatHTML(@BeanParam MultiPartRunConfiguration runConfiguration, @Valid @BeanParam MultiPartArgumentFilesBean argumentFiles) throws RunSubmissionFailureException, RunCollectionCreationException, RefNotFoundException {
        String id = this.postRunMultiPartFormat(runConfiguration, argumentFiles);
        return Response.seeOther((URI)this.getRunStateURI(id)).build();
    }

    @POST
    @Path(value="premium_priority")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String postPremiumRunFormFormat(@BeanParam FormRunConfiguration runConfiguration, @Valid @BeanParam FormArgumentFilesBean argumentFiles) throws RunSubmissionFailureException, RunCollectionCreationException, RefNotFoundException {
        DefaultStartRunInformation startRunInformation = new DefaultStartRunInformation(runConfiguration, argumentFiles, true);
        this.logf("Received submission request: %s", startRunInformation);
        return this.vCloud.startTool(startRunInformation).toString();
    }

    @POST
    @Path(value="premium_priority")
    @Produces(value={"text/plain"})
    @Consumes(value={"multipart/form-data"})
    public String postPremiumRunMultiPartFormat(@BeanParam MultiPartRunConfiguration runConfiguration, @Valid @BeanParam MultiPartArgumentFilesBean argumentFiles) throws RunSubmissionFailureException, RunCollectionCreationException, RefNotFoundException {
        DefaultStartRunInformation startRunInformation = new DefaultStartRunInformation(runConfiguration, argumentFiles, true);
        this.logf("Received submission request: %s", startRunInformation);
        return this.vCloud.startTool(startRunInformation).toString();
    }

    private URI getRunStateURI(String id) {
        UriBuilder builder;
        Optional<URI> configuredBasePath = this.vCloud.getConfiguredBasePath();
        if (configuredBasePath.isPresent()) {
            builder = UriBuilder.fromUri((URI)configuredBasePath.get());
            builder.path("runs/");
        } else {
            builder = this.uriInfo.getRequestUriBuilder();
        }
        return builder.path(id).path("state").build(new Object[0]);
    }

    @DELETE
    @Path(value="{id}")
    public void deleteRun(@PathParam(value="id") UUID id) throws RequestFailureException, MasterSummaryNotRetrievableException {
        this.logf("Received delete request for run id %s.", id);
        this.vCloud.removeRun(id);
    }

    @GET
    @Path(value="{id}/result")
    @Produces(value={"application/zip"})
    public Response getRunResultAsZip(@PathParam(value="id") UUID id) throws TimeoutException, IOException, RequestFailureException {
        this.logf("Received result request for run id %s.", id);
        final FileContent result = this.vCloud.getResult(id);
        ContentDisposition contentDisposition = ContentDisposition.type((String)"attachment").fileName("result-" + id + ".zip").build();
        return Response.ok((Object)new StreamingOutput(){

            public void write(OutputStream outputStream) throws IOException {
                result.getContentAsByteSource().copyTo(outputStream);
                outputStream.flush();
            }
        }).header("Content-Disposition", (Object)contentDisposition).build();
    }

    @GET
    @Path(value="{id}/state")
    @Produces(value={"text/plain"})
    public String getRunState(@PathParam(value="id") UUID runID) throws MasterSummaryNotRetrievableException {
        this.logf("Received state request for run id %s.", runID);
        return this.vCloud.getRunState(runID).toString();
    }

    @GET
    @Path(value="{id}/state")
    @Produces(value={"text/html"})
    @Template(name="/state")
    public Map<String, Object> getRunStateHTML(@PathParam(value="id") UUID runID) throws MasterSummaryNotRetrievableException {
        this.logf("Received state request for run id %s.", runID);
        return this.vCloud.getModelGenerator().getRunStateModel(this.uriInfo, runID);
    }

    private void logf(String message, Object ... args) {
        String formattedMessage = String.format(message, args);
        this.vCloud.getLogger().logf(Level.FINE, "%s@%s: %s", this.remoteUser, this.remoteAdress, formattedMessage);
    }
}

