/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.resources;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.glassfish.jersey.media.multipart.ContentDisposition;
import org.glassfish.jersey.server.mvc.Template;
import org.sosy_lab.verifiercloud.client.applications.webclient.api.WebClientAPI;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.ProgramNotAvailableException;
import org.sosy_lab.verifiercloud.client.applications.webclient.resources.RunsResource;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.beans.QuerySvnRevisionBean;
import org.sosy_lab.verifiercloud.client.network.exceptions.MasterSummaryNotRetrievableException;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;

@Path(value="webclient/")
public class WebClientResource {
    public static final String WEBCLIENT_PATH = "webclient/";
    public static final String RUNS_PATH = "runs/";
    public static final String MASTER_SUMMARY_PATH = "master/info";
    public static final String TOOL = "tool/";
    public static final String HELP_PATH = "help/";
    private final WebClientAPI vCloud;
    private final String remoteAdress;
    private final String remoteUser;

    @Inject
    public WebClientResource(@Context HttpServletRequest request, WebClientAPI vCloud) {
        if (request != null) {
            this.remoteAdress = request.getRemoteAddr();
            String remoteUser = request.getRemoteUser();
            this.remoteUser = remoteUser == null ? "anonymousUser" : remoteUser;
        } else {
            this.remoteAdress = "unknown";
            this.remoteUser = "unknownUser";
        }
        this.vCloud = Preconditions.checkNotNull(vCloud);
    }

    @Path(value="runs/")
    public Class<RunsResource> getHTMLSubmissionPage(@Context UriInfo uriInfo) {
        return RunsResource.class;
    }

    @GET
    @Path(value="tool/")
    @Produces(value={"application/zip"})
    public Response getTool(@BeanParam QuerySvnRevisionBean revisionBean) throws RefNotFoundException, IOException, ProgramNotAvailableException {
        SvnRevision svnRevision = revisionBean.getSvnRevision();
        this.logf("Received tool request for revision %s.", svnRevision);
        final FileContent tool = this.vCloud.getTool(svnRevision);
        String svnName = svnRevision.getBranchOrTagName();
        ContentDisposition contentDisposition = ContentDisposition.type((String)"attachment").fileName("tool-" + svnName + ".zip").build();
        return Response.ok((Object)new StreamingOutput(){

            public void write(OutputStream outputStream) throws IOException {
                tool.getContentAsByteSource().copyTo(outputStream);
                outputStream.flush();
            }
        }).header("Content-Disposition", (Object)contentDisposition).build();
    }

    @GET
    @Path(value="master/info")
    @Produces(value={"text/html"})
    public String getVcloudStatus() throws MasterSummaryNotRetrievableException {
        this.logf("Received info request.", new Object[0]);
        return this.vCloud.getVcloudInfo();
    }

    @GET
    public Response redirectToHelpText(@Context UriInfo uriInfo) {
        Optional<URI> configuredBasePath = this.vCloud.getConfiguredBasePath();
        UriBuilder builder = configuredBasePath.isPresent() ? UriBuilder.fromUri((URI)configuredBasePath.get()) : uriInfo.getRequestUriBuilder();
        URI helpLocation = builder.path(HELP_PATH).build(new Object[0]);
        return Response.seeOther((URI)helpLocation).build();
    }

    @GET
    @Path(value="help/")
    @Produces(value={"text/html"})
    @Template(name="/help")
    public Map<String, Object> getHelpHTML(@Context UriInfo uriInfo) {
        this.logf("Received GET request. Response is help text as HTML.", new Object[0]);
        return this.vCloud.getModelGenerator().getHelpModel(uriInfo);
    }

    @GET
    @Path(value="update_repository")
    public Response triggerRepositoryUpdate() {
        this.logf("Received repository update trigger.", new Object[0]);
        this.vCloud.updateRepository();
        return Response.ok().build();
    }

    private void logf(String message, Object ... args) {
        String formattedMessage = String.format(message, args);
        this.vCloud.getLogger().logf(Level.FINE, "%s@%s: %s", this.remoteUser, this.remoteAdress, formattedMessage);
    }
}

