/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.LimitationsBean;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.LimitationsBuilder;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class AbstractLimitationsBean
implements LimitationsBean {
    public static final String LIMITATIONS = "limitations";
    public static final String TIME_LIMITATION = "timeLimitation";
    public static final String MEMORY_LIMITATION = "memoryLimitation";
    public static final String CORE_LIMITATION = "coreLimitation";
    private final Limitations limitations;

    @Inject
    public AbstractLimitationsBean(ImmutableMap<String, Limitations> preDefinedLimitationsMapping, @Nullable String preDifinedLimitationsName, @Nullable TimeInterval timeLimitation, @Nullable MemoryUnit memoryLimitation, @Nullable Integer coreLimitation) {
        Preconditions.checkArgument(!preDefinedLimitationsMapping.isEmpty());
        Limitations preDefinedLimitations = preDifinedLimitationsName != null && preDefinedLimitationsMapping.containsKey(preDifinedLimitationsName) ? preDefinedLimitationsMapping.get(preDifinedLimitationsName) : (Limitations)((Map.Entry)((ImmutableSet)preDefinedLimitationsMapping.entrySet()).iterator().next()).getValue();
        LimitationsBuilder limitationsBuilder = LimitationsBuilder.from(preDefinedLimitations);
        if (timeLimitation != null) {
            limitationsBuilder.setTimeLimit(timeLimitation);
        }
        if (memoryLimitation != null) {
            limitationsBuilder.setMemoryLimit(memoryLimitation);
        }
        if (coreLimitation != null) {
            limitationsBuilder.setCoreLimit(coreLimitation);
        }
        this.limitations = limitationsBuilder.build();
    }

    @Override
    public Limitations getLimitations() {
        return this.limitations;
    }

    public int hashCode() {
        return this.limitations.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LimitationsBean)) {
            return false;
        }
        LimitationsBean that = (LimitationsBean)other;
        return this.getLimitations().equals(that.getLimitations());
    }

    public String toString() {
        return this.limitations.toString();
    }

    public static Iterable<String> getOptionsDescription() {
        return ImmutableList.of("limitations: One of the pre defined limitations. Default is the first one.", "timeLimitation: Sets the time limitation and replaces the value of the pre defined limitation. If no unit is given seconds are assumed.", "memoryLimitation: Sets the memory limitation and replaces the value of the pre defined limitation. If no unit is given bytes are assumed.", "coreLimitation: Sets the cpu core limitation and replaces  the value of the pre defined limitation.");
    }
}

