/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.DefaultStartRunInformation;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.LimitationsBean;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.RunConfiguration;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.form_format.FormLimitationsBean;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.beans.FormSvnRevisionBean;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.beans.SvnRevisionBean;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class AbstractRunConfiguration
implements RunConfiguration {
    public static final String OPTION = "option";
    public static final String CONFIG = "configuration";
    public static final String SPEC = "specification";
    public static final String CPU_MODEL = "cpuModel";
    public static final String MAX_HEAP_SIZE = "heap";
    public static final String DISABLE_JAVA_ASSERTIONS = "disableJavaAssertions";
    public static final String DISABLE_JAVA_ASSERTIONS_DEFAULT = "false";
    private final Optional<String> cpuModel;
    private final Optional<String> configuration;
    private final Optional<String> specification;
    private final ImmutableSet<String> additionalOptions;
    private final Optional<MemoryUnit> maxHeapSize;
    private final boolean disableJavaAssertions;
    private final LimitationsBean limitationsBean;
    private final SvnRevisionBean svnRevisionBean;
    private final Optional<String> userName;

    @Inject
    public AbstractRunConfiguration(Optional<String> cpuModel, Optional<String> configuration, Optional<String> specification, Set<String> additionalOptions, Optional<MemoryUnit> maxHeapSize, boolean disableJavaAssertions, LimitationsBean limitationsBean, SvnRevisionBean svnRevisionBean, Optional<String> userName) {
        this.cpuModel = Preconditions.checkNotNull(cpuModel);
        this.configuration = Preconditions.checkNotNull(configuration);
        this.specification = Preconditions.checkNotNull(specification);
        this.additionalOptions = FluentIterable.from(additionalOptions).filter(Predicates.not(Predicates.equalTo(""))).toSet();
        this.maxHeapSize = Preconditions.checkNotNull(maxHeapSize);
        this.disableJavaAssertions = disableJavaAssertions;
        this.limitationsBean = Preconditions.checkNotNull(limitationsBean);
        this.svnRevisionBean = Preconditions.checkNotNull(svnRevisionBean);
        this.userName = Preconditions.checkNotNull(userName);
    }

    @Override
    public Limitations getLimitations() {
        return this.limitationsBean.getLimitations();
    }

    @Override
    public Optional<String> getCpuModel() {
        return this.cpuModel;
    }

    @Override
    public ImmutableSet<String> getAdditionalOptions() {
        return this.additionalOptions;
    }

    @Override
    public Optional<MemoryUnit> getMaxHeapSize() {
        return this.maxHeapSize;
    }

    @Override
    public boolean disableJavaAssertions() {
        return this.disableJavaAssertions;
    }

    @Override
    public Optional<String> getConfiguration() {
        return this.configuration;
    }

    @Override
    public Optional<String> getSpecification() {
        return this.specification;
    }

    @Override
    public SvnRevision getSvnRevision() {
        return this.svnRevisionBean.getSvnRevision();
    }

    @Override
    public Optional<String> getUserName() {
        return this.userName;
    }

    public int hashCode() {
        return Objects.hash(this.getLimitations(), this.getCpuModel(), this.getAdditionalOptions(), this.getConfiguration(), this.getSpecification(), this.getSvnRevision(), this.getUserName());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RunConfiguration)) {
            return false;
        }
        RunConfiguration that = (RunConfiguration)other;
        return this.getLimitations().equals(that.getLimitations()) && this.getCpuModel().equals(that.getCpuModel()) && this.getAdditionalOptions().equals(that.getAdditionalOptions()) && this.getMaxHeapSize().equals(that.getMaxHeapSize()) && this.disableJavaAssertions() == that.disableJavaAssertions() && this.getConfiguration().equals(that.getConfiguration()) && this.getSpecification().equals(that.getSpecification()) && this.getSvnRevision().equals(that.getSvnRevision()) && this.getUserName().equals(that.getUserName());
    }

    public String toString() {
        return DefaultStartRunInformation.class.getSimpleName() + "[limitations: " + this.getLimitations() + ", cpu model: " + (this.getCpuModel().isPresent() ? this.getCpuModel().get() : "-") + ", configuration: " + (this.getConfiguration().isPresent() ? this.getConfiguration().get() : "-") + ", specification: " + (this.getSpecification().isPresent() ? this.getSpecification().get() : "-") + ", additional options: " + this.getAdditionalOptions() + ", max heap size: " + (this.getMaxHeapSize().isPresent() ? (Serializable)this.getMaxHeapSize().get() : "-") + ", disable Java assertions: " + this.disableJavaAssertions() + ", revision: " + this.getSvnRevision() + ", userName: " + (this.getUserName().isPresent() ? this.getUserName().get() : "-") + "]";
    }

    public static Iterable<String> getOptionsDescription() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("cpuModel: Specifies the CPU model. The run will be executed on a CPU if the given string is substring of its name. Default is no restriction.")).add("configuration: A configuration from the repository (optional), e.g. configuration=ldv")).add("specification: A specfication from the repository (optional), e.g. specification=Assertion")).add("option: Additional options as key value pairs (e.g. option=log.level=FINE). Can be used more than once. Not all options are allowed (optional).")).add("heap: Sets the maximum heap size of the CPAchecker's JVM (optional). If no unit is given bytes are assumed.")).add("disableJavaAssertions: Disables Java assertions.")).addAll(FormLimitationsBean.getOptionsDescription())).addAll(FormSvnRevisionBean.getOptionsDescription())).build();
    }

    protected static Optional<String> extractUserName(@Nullable HttpServletRequest request) {
        if (request == null) {
            return Optional.absent();
        }
        return Optional.fromNullable(request.getRemoteUser());
    }
}

