/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.Objects;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.ArgumentFilesBean;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.RunConfiguration;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.StartRunInformation;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class DefaultStartRunInformation
implements StartRunInformation {
    private final RunConfiguration runConfiguration;
    private final ArgumentFilesBean argumentFiles;
    private final boolean premiumUserPriority;

    public DefaultStartRunInformation(RunConfiguration runConfiguration, ArgumentFilesBean argumentFiles, boolean premiumUserPriority) {
        this.runConfiguration = Preconditions.checkNotNull(runConfiguration);
        this.argumentFiles = Preconditions.checkNotNull(argumentFiles);
        this.premiumUserPriority = premiumUserPriority;
    }

    @Override
    public Limitations getLimitations() {
        return this.runConfiguration.getLimitations();
    }

    @Override
    public Optional<String> getCpuModel() {
        return this.runConfiguration.getCpuModel();
    }

    @Override
    public ImmutableSet<String> getAdditionalOptions() {
        return this.runConfiguration.getAdditionalOptions();
    }

    @Override
    public Optional<MemoryUnit> getMaxHeapSize() {
        return this.runConfiguration.getMaxHeapSize();
    }

    @Override
    public boolean disableJavaAssertions() {
        return this.runConfiguration.disableJavaAssertions();
    }

    @Override
    public Optional<String> getConfiguration() {
        return this.runConfiguration.getConfiguration();
    }

    @Override
    public Optional<String> getSpecification() {
        return this.runConfiguration.getSpecification();
    }

    @Override
    public SvnRevision getSvnRevision() {
        return this.runConfiguration.getSvnRevision();
    }

    @Override
    public Optional<String> getUserName() {
        return this.runConfiguration.getUserName();
    }

    @Override
    public Optional<String> getSpecificationText() {
        return this.argumentFiles.getSpecificationText();
    }

    @Override
    public Optional<String> getPropertyText() {
        return this.argumentFiles.getPropertyText();
    }

    @Override
    public Optional<String> getErrorWitnessText() {
        return this.argumentFiles.getErrorWitnessText();
    }

    @Override
    public ImmutableMap<Path, String> getProgramTexts() {
        return this.argumentFiles.getProgramTexts();
    }

    @Override
    public boolean isPremiumUserPriority() {
        return this.premiumUserPriority;
    }

    public int hashCode() {
        return Objects.hash(this.getLimitations(), this.getCpuModel(), this.getAdditionalOptions(), this.getMaxHeapSize(), this.disableJavaAssertions(), this.getConfiguration(), this.getSpecification(), this.getSvnRevision(), this.getUserName(), this.getSpecificationText(), this.getProgramTexts(), this.isPremiumUserPriority());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StartRunInformation)) {
            return false;
        }
        StartRunInformation that = (StartRunInformation)other;
        return this.getProgramTexts().equals(that.getProgramTexts()) && this.getLimitations().equals(that.getLimitations()) && this.getCpuModel().equals(that.getCpuModel()) && this.getAdditionalOptions().equals(that.getAdditionalOptions()) && this.getMaxHeapSize().equals(that.getMaxHeapSize()) && this.disableJavaAssertions() == that.disableJavaAssertions() && this.getConfiguration().equals(that.getConfiguration()) && this.getSpecification().equals(that.getSpecification()) && this.getSvnRevision().equals(that.getSvnRevision()) && this.getUserName().equals(that.getUserName()) && this.getSpecificationText().equals(that.getSpecificationText()) && this.getProgramTexts().equals(that.getProgramTexts()) && this.isPremiumUserPriority() == that.isPremiumUserPriority();
    }

    public String toString() {
        return DefaultStartRunInformation.class.getSimpleName() + "[" + this.runConfiguration + ", " + (this.isPremiumUserPriority() ? "premium user" : "normal User") + "]";
    }
}

