/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.form_format;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.FormParam;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.ArgumentFilesBean;

public class FormArgumentFilesBean
implements ArgumentFilesBean {
    public static final String PROGRAM_TEXT = "programText";
    public static final String SPEC = "specificationText";
    public static final String PROP = "propertyText";
    public static final String WITNESS = "errorWitnessText";
    @NotNull(message="Missing verification file. Use POST parameter 'programText'.")
    @FormParam(value="programText")
    private String firstProgramText;
    private final ImmutableMap<Path, String> programTexts;
    private final Optional<String> specificationText;
    private final Optional<String> propertyText;
    private final Optional<String> errorWitnessText;

    @Inject
    public FormArgumentFilesBean(@FormParam(value="programText") List<String> programTexts, @FormParam(value="specificationText") String specificationText, @FormParam(value="propertyText") String propertyText, @FormParam(value="errorWitnessText") String errorWitnessText) {
        this.specificationText = Optional.fromNullable(Strings.emptyToNull(specificationText));
        this.propertyText = Optional.fromNullable(Strings.emptyToNull(propertyText));
        this.errorWitnessText = Optional.fromNullable(Strings.emptyToNull(errorWitnessText));
        ImmutableMap.Builder<Path, String> cFilesBuilder = ImmutableMap.builder();
        for (int i = 0; i < programTexts.size(); ++i) {
            String cFileContent = programTexts.get(i);
            String fileName = "cFile" + i + ".c";
            if (Strings.isNullOrEmpty(cFileContent)) continue;
            cFilesBuilder.put(Paths.get(fileName, new String[0]), cFileContent);
        }
        this.programTexts = cFilesBuilder.build();
    }

    @Override
    public Optional<String> getSpecificationText() {
        return this.specificationText;
    }

    @Override
    public Optional<String> getPropertyText() {
        return this.propertyText;
    }

    @Override
    public Optional<String> getErrorWitnessText() {
        return this.errorWitnessText;
    }

    @Override
    public ImmutableMap<Path, String> getProgramTexts() {
        return this.programTexts;
    }

    public static Iterable<String> getOptionsDescription() {
        return ImmutableList.of("programText: The file(s) as program text to verify (not optional). It can be used several times, once for each program text.", "specificationText: A specification as text (optional).", "propertyText: A property as text (optional).", "errorWitnessText: An error-witness automaton (optional).");
    }
}

