/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.multi_part_format;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.ArgumentFilesBean;

public class MultiPartArgumentFilesBean
implements ArgumentFilesBean {
    private static final String PROGRAM_TEXT = "programText";
    private static final String SPEC = "specificationText";
    private static final String PROP = "propertyText";
    private static final String WITNESS = "errorWitnessText";
    @NotNull(message="Missing verification file. Use parameter 'programText'.")
    @FormDataParam(value="programText")
    private String firstCFileContent;
    private final ImmutableMap<Path, String> programTexts;
    private final Optional<String> specificationText;
    private final Optional<String> propertyText;
    private final Optional<String> errorWitnessText;

    @Inject
    public MultiPartArgumentFilesBean(@FormDataParam(value="programText") List<FormDataContentDisposition> fileDispositions, @FormDataParam(value="programText") List<String> programContents, @FormDataParam(value="specificationText") String specificationText, @FormDataParam(value="propertyText") String propertyText, @FormDataParam(value="errorWitnessText") String errorWitnessText) {
        this.specificationText = Optional.fromNullable(Strings.emptyToNull(specificationText));
        this.propertyText = Optional.fromNullable(Strings.emptyToNull(propertyText));
        this.errorWitnessText = Optional.fromNullable(Strings.emptyToNull(errorWitnessText));
        Preconditions.checkArgument(programContents.size() == fileDispositions.size());
        ImmutableMap.Builder<Path, String> programTextsBuilder = ImmutableMap.builder();
        for (int i = 0; i < programContents.size(); ++i) {
            String cFileContent = programContents.get(i);
            String fileName = fileDispositions.get(i).getFileName();
            if (fileName == null || fileName.isEmpty()) {
                fileName = "cFile" + i + ".c";
            }
            if (Strings.isNullOrEmpty(cFileContent)) continue;
            programTextsBuilder.put(Paths.get(fileName, new String[0]), cFileContent);
        }
        this.programTexts = programTextsBuilder.build();
    }

    @Override
    public Optional<String> getSpecificationText() {
        return this.specificationText;
    }

    @Override
    public Optional<String> getPropertyText() {
        return this.propertyText;
    }

    @Override
    public Optional<String> getErrorWitnessText() {
        return this.errorWitnessText;
    }

    @Override
    public ImmutableMap<Path, String> getProgramTexts() {
        return this.programTexts;
    }
}

