/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision;

import com.google.common.base.Preconditions;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnBranchAndRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnBranchHead;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevisionPattern;

public class AllSvnBranches
implements SvnRevisionPattern {
    private final int firstAllowedRevision;

    public AllSvnBranches(int firstAllowedRevision) {
        Preconditions.checkArgument(firstAllowedRevision >= 0);
        this.firstAllowedRevision = firstAllowedRevision;
    }

    @Override
    public boolean matches(SvnRevision revision) {
        if (revision instanceof SvnBranchHead) {
            return true;
        }
        if (revision instanceof SvnBranchAndRevision) {
            int revisionNumber = ((SvnBranchAndRevision)revision).getRevisionNumber();
            return this.firstAllowedRevision <= revisionNumber;
        }
        return false;
    }

    @Override
    public SvnRevision getRevisionForPreComputing() {
        return new SvnBranchHead("trunk");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AllSvnBranches)) {
            return false;
        }
        AllSvnBranches that = (AllSvnBranches)other;
        return this.firstAllowedRevision == that.firstAllowedRevision;
    }

    public int hashCode() {
        return this.firstAllowedRevision;
    }

    public String toString() {
        return "*:" + this.firstAllowedRevision + "-HEAD";
    }
}

