/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sosy_lab.verifiercloud.client.applications.webclient.git_handling.GitManager;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.ImmutableSvnRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;

public class SvnBranchAndRevision
implements ImmutableSvnRevision {
    private final String branch;
    private final int revisionNumber;

    public SvnBranchAndRevision(String branch, int revision) {
        this.branch = Preconditions.checkNotNull(branch);
        this.revisionNumber = revision;
    }

    @Override
    public ImmutableSvnRevision getCurrentRevision(GitManager gitManager) {
        return this;
    }

    @Override
    public String getBranchOrTagName() {
        return this.getBranch();
    }

    @Override
    public int getRevisionNumber() {
        return this.revisionNumber;
    }

    public String getBranch() {
        return this.branch;
    }

    @Override
    public String getGitBranch() {
        return "origin/" + this.getBranch();
    }

    @Override
    public boolean matches(SvnRevision revision) {
        return this.equals(revision);
    }

    @Override
    public SvnRevision getRevisionForPreComputing() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.branch, this.revisionNumber);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SvnBranchAndRevision)) {
            return false;
        }
        SvnBranchAndRevision that = (SvnBranchAndRevision)other;
        return this.getBranch().equals(that.getBranch()) && this.getRevisionNumber() == that.getRevisionNumber();
    }

    public String toString() {
        return this.branch + ":" + this.revisionNumber;
    }
}

