/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.sosy_lab.verifiercloud.client.applications.webclient.git_handling.GitManager;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnBranchAndRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;

public class SvnBranchHead
implements SvnRevision {
    private final String branch;

    public SvnBranchHead(String branch) {
        this.branch = Preconditions.checkNotNull(branch);
    }

    @Override
    public SvnBranchAndRevision getCurrentRevision(GitManager gitManager) throws IOException, RefNotFoundException {
        int lastRevisionNumber = gitManager.getCurrentRevision(this);
        return new SvnBranchAndRevision(this.branch, lastRevisionNumber);
    }

    @Override
    public String getBranchOrTagName() {
        return this.getBranch();
    }

    public String getBranch() {
        return this.branch;
    }

    @Override
    public String getGitBranch() {
        return "origin/" + this.getBranch();
    }

    @Override
    public boolean matches(SvnRevision revision) {
        return this.equals(revision);
    }

    @Override
    public SvnRevision getRevisionForPreComputing() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.branch);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SvnBranchHead)) {
            return false;
        }
        SvnBranchHead that = (SvnBranchHead)other;
        return this.getBranch().equals(that.getBranch());
    }

    public String toString() {
        return this.branch + ":HEAD";
    }
}

