/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.sosy_lab.verifiercloud.client.applications.webclient.git_handling.GitManager;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnTagAndRevision;

public class SvnTag
implements SvnRevision {
    private final String tagName;

    public SvnTag(String tagName) {
        this.tagName = Preconditions.checkNotNull(tagName);
    }

    @Override
    public SvnTagAndRevision getCurrentRevision(GitManager gitManager) throws IOException, RefNotFoundException {
        int lastRevisionNumber = gitManager.getCurrentRevision(this);
        return new SvnTagAndRevision(this.tagName, lastRevisionNumber);
    }

    @Override
    public String getBranchOrTagName() {
        return this.getTag();
    }

    public String getTag() {
        return this.tagName;
    }

    @Override
    public String getGitBranch() {
        return "origin/tags/" + this.getTag();
    }

    @Override
    public boolean matches(SvnRevision revision) {
        return this.equals(revision);
    }

    @Override
    public SvnRevision getRevisionForPreComputing() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.tagName);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SvnTag)) {
            return false;
        }
        SvnTag that = (SvnTag)other;
        return this.getTag().equals(that.getTag());
    }

    public String toString() {
        return this.tagName;
    }
}

