/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sosy_lab.verifiercloud.client.applications.webclient.git_handling.GitManager;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.ImmutableSvnRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;

public class SvnTagAndRevision
implements ImmutableSvnRevision {
    private final String tag;
    private final int revisionNumber;

    public SvnTagAndRevision(String tag, int revision) {
        this.tag = Preconditions.checkNotNull(tag);
        this.revisionNumber = revision;
    }

    @Override
    public ImmutableSvnRevision getCurrentRevision(GitManager gitManager) {
        return this;
    }

    @Override
    public String getBranchOrTagName() {
        return this.getTag();
    }

    @Override
    public int getRevisionNumber() {
        return this.revisionNumber;
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public String getGitBranch() {
        return "origin/tags/" + this.getTag();
    }

    @Override
    public boolean matches(SvnRevision revision) {
        return this.equals(revision);
    }

    @Override
    public SvnRevision getRevisionForPreComputing() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.revisionNumber);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SvnTagAndRevision)) {
            return false;
        }
        SvnTagAndRevision that = (SvnTagAndRevision)other;
        return this.getTag().equals(that.getTag()) && this.getRevisionNumber() == that.getRevisionNumber();
    }

    public String toString() {
        return this.tag + ":" + this.revisionNumber;
    }
}

