/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.beans;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnBranchAndRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnBranchHead;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnTag;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.beans.SvnRevisionBean;

public class AbstractSvnRevisionBean
implements SvnRevisionBean {
    public static final String REVISION = "revision";
    public static final String SVN_BRANCH = "svnBranch";
    public static final String SVN_TAG = "svnTag";
    protected static final String HEAD = "HEAD";
    protected static final String TRUNK = "trunk";
    private final SvnRevision svnRevision;

    public AbstractSvnRevisionBean(String svnRevisionNumber, String svnBranch, @Nullable String svnTag) {
        if (svnTag == null) {
            if (svnRevisionNumber.equalsIgnoreCase(HEAD)) {
                this.svnRevision = new SvnBranchHead(svnBranch);
            } else {
                int revisionNumber = Integer.parseInt(svnRevisionNumber);
                this.svnRevision = new SvnBranchAndRevision(svnBranch, revisionNumber);
            }
        } else {
            this.svnRevision = new SvnTag(svnTag);
        }
    }

    @Override
    public SvnRevision getSvnRevision() {
        return this.svnRevision;
    }

    public int hashCode() {
        return this.svnRevision.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SvnRevisionBean)) {
            return false;
        }
        SvnRevisionBean that = (SvnRevisionBean)other;
        return this.getSvnRevision().equals(that.getSvnRevision());
    }

    public String toString() {
        return this.svnRevision.toString();
    }

    public static Iterable<String> getOptionsDescription() {
        return ImmutableList.of("revision: 'HEAD' or a positive integer representing the svn revision. Default is 'HEAD'.", "svnBranch: A svn branch name or 'trunk'. Default is 'trunk'", "svnTag: A svn tag name. If set revision and svnBranch are ignored.");
    }
}

