/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.validation;

import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.validation.ValidationException;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.StartRunInformation;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevisionPattern;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.validation.StartRunInformationValidator;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class DefaultStartRunInformationValidator
implements StartRunInformationValidator {
    private static final CharMatcher disallowedToolOptionsChars = CharMatcher.anyOf("<>&|; ").precomputed();
    private static final Splitter optionSplitter = Splitter.on('=').trimResults();
    private final TimeInterval maxTimeLimitation;
    private final MemoryUnit maxMemoryLimitation;
    private final int maxCpuCoreLimitation;
    private final ImmutableSet<SvnRevisionPattern> allowedSvnRevisions;
    private final ImmutableSet<String> disallowedSpecAndConfig;
    private final Pattern configAndSpecPattern;
    private final Logger logger;

    @Inject
    public DefaultStartRunInformationValidator(@Named(value="timeLimitation") TimeInterval timeLimitation, @Named(value="memoryRequirementLimitation") MemoryUnit memoryLimitation, @Named(value="coresRequirementLimitation") int cpuCoreLimitation, @Named(value="allowedRevisionsAndBranches") ImmutableSet<SvnRevisionPattern> allowedSvnRevisions, @Named(value="disallowedSpecAndConfig") ImmutableSet<String> disallowedSpecAndConfig, @Named(value="configAndSpecPattern") String configAndSpecPattern, Logger logger) {
        this.maxTimeLimitation = Preconditions.checkNotNull(timeLimitation);
        this.maxMemoryLimitation = Preconditions.checkNotNull(memoryLimitation);
        this.maxCpuCoreLimitation = cpuCoreLimitation;
        this.allowedSvnRevisions = Preconditions.checkNotNull(allowedSvnRevisions);
        this.disallowedSpecAndConfig = Preconditions.checkNotNull(disallowedSpecAndConfig);
        this.configAndSpecPattern = Pattern.compile(configAndSpecPattern);
        this.logger = Preconditions.checkNotNull(logger);
    }

    @Override
    public void validate(StartRunInformation startRunInformation) throws ValidationException {
        Optional<String> spec;
        Optional<String> config;
        FluentIterable<SvnRevisionPattern> patterns;
        boolean allowed;
        Optional<MemoryUnit> givenMemeoryLimitation;
        StringBuilder errorMessage = new StringBuilder();
        boolean securityViaolation = false;
        TimeInterval givenTimeLimitation = startRunInformation.getLimitations().getTimeLimit();
        if (givenTimeLimitation.isGreater(this.maxTimeLimitation)) {
            this.logAndAddToErrorMessages(errorMessage, "The time limiations %s is greater than the defined maximum time limitation %s.", givenTimeLimitation, this.maxTimeLimitation);
            securityViaolation = true;
        }
        if (!(givenMemeoryLimitation = startRunInformation.getLimitations().getMemoryLimit()).isPresent()) {
            this.logAndAddToErrorMessages(errorMessage, "No memory limitation is given.", new Object[0]);
            securityViaolation = true;
        } else if (givenMemeoryLimitation.get().isGreaterThan(this.maxMemoryLimitation)) {
            this.logAndAddToErrorMessages(errorMessage, "The memory limiations %s is greater than the defined maximum memory limitation %s.", givenMemeoryLimitation.get(), this.maxMemoryLimitation);
            securityViaolation = true;
        }
        Optional<Integer> givenCoreLimitation = startRunInformation.getLimitations().getProcessorLimit();
        if (!givenCoreLimitation.isPresent()) {
            this.logAndAddToErrorMessages(errorMessage, "No cpu core limitation is given.", new Object[0]);
            securityViaolation = true;
        } else if (givenCoreLimitation.get() > this.maxCpuCoreLimitation) {
            this.logAndAddToErrorMessages(errorMessage, "The cpu core limiations %s is greater than the defined maximum cpu core limitation %s.", givenCoreLimitation.get(), this.maxCpuCoreLimitation);
            securityViaolation = true;
        }
        final SvnRevision svnRevision = startRunInformation.getSvnRevision();
        if (!this.allowedSvnRevisions.contains(svnRevision) && !(allowed = (patterns = FluentIterable.from(this.allowedSvnRevisions)).anyMatch(new Predicate<SvnRevisionPattern>(){

            @Override
            public boolean apply(SvnRevisionPattern pattern) {
                return pattern.matches(svnRevision);
            }
        }))) {
            this.logAndAddToErrorMessages(errorMessage, "%s is not an allowed svn revision.", svnRevision);
            securityViaolation = true;
        }
        if ((config = startRunInformation.getConfiguration()).isPresent() && (!this.configAndSpecPattern.matcher(config.get()).matches() || this.disallowedSpecAndConfig.contains(config.get()))) {
            this.logAndAddToErrorMessages(errorMessage, "%s: disallowed configuration.", config.get());
            securityViaolation = true;
        }
        if ((spec = startRunInformation.getSpecification()).isPresent() && (!this.configAndSpecPattern.matcher(spec.get()).matches() || this.disallowedSpecAndConfig.contains(spec.get()))) {
            this.logAndAddToErrorMessages(errorMessage, "%s: disallowed specification.", spec.get());
            securityViaolation = true;
        }
        ImmutableSet<String> additionalOptions = startRunInformation.getAdditionalOptions();
        for (String option : additionalOptions) {
            List<String> tokens;
            String illegalCharacters = disallowedToolOptionsChars.retainFrom(option);
            if (!illegalCharacters.isEmpty()) {
                this.logAndAddToErrorMessages(errorMessage, "Option '%s' contains disallowed characters '%s'", option, illegalCharacters);
                securityViaolation = true;
            }
            if ((tokens = optionSplitter.splitToList(option)).size() >= 2) continue;
            this.logAndAddToErrorMessages(errorMessage, "%s has invalid tokens size. It does not match <key>=<value>.", option);
            securityViaolation = true;
        }
        this.checkSecurityViaolation(securityViaolation, errorMessage);
    }

    private void checkSecurityViaolation(boolean securityViaolation, StringBuilder errorMessage) throws ValidationException {
        if (securityViaolation) {
            Preconditions.checkState(errorMessage.length() > 0);
            throw new ValidationException(errorMessage.toString());
        }
    }

    private void logAndAddToErrorMessages(StringBuilder errorMessageBuilder, String message, Object ... args) {
        String formattedErrorMessage = String.format(message, args);
        this.logger.logf(Level.INFO, formattedErrorMessage, new Object[0]);
        if (errorMessageBuilder.length() > 0) {
            errorMessageBuilder.append('\n');
        }
        errorMessageBuilder.append(formattedErrorMessage);
    }
}

