/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.configuration.benchmark;

import com.google.common.collect.ImmutableSet;
import java.io.PrintWriter;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.Configuration;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToBooleanFunction;

public final class BenchmarkClientConfiguration
extends Configuration {
    public static final String PRINT_NEW_FILES = "print-new-files";
    private final ConfigurationOption<Boolean> printNewFiles = new DefaultConfigurationOption<Boolean>("print-new-files", "Writes all paths of files created on the worker during the run execution into a file.", "(true|false)", false, new StringToBooleanFunction());
    private final ImmutableSet<ConfigurationOption<?>> options = ImmutableSet.of(this.printNewFiles);

    @Override
    public ImmutableSet<ConfigurationOption<?>> getAllConfigurationOptions() {
        return this.options;
    }

    public static ImmutableSet<ConfigurationOption<?>> getConfigurationOptions() {
        return new BenchmarkClientConfiguration().getAllConfigurationOptions();
    }

    @Override
    public void write(PrintWriter writer) {
        writer.println("# The general client configuration file is Config. This is the benchmark client specific configuration:");
        writer.println();
        super.write(writer);
    }

    public static DefaultConfigurationBuilder<BenchmarkClientConfiguration> getDefaultConfigurationBuilder() {
        return new DefaultConfigurationBuilder<BenchmarkClientConfiguration>(){

            @Override
            public BenchmarkClientConfiguration getDefaultConfiguration() {
                return new BenchmarkClientConfiguration();
            }
        };
    }

    public static String getOptions() {
        return BenchmarkClientConfiguration.buildOptionsString(BenchmarkClientConfiguration.getConfigurationOptions());
    }
}

