/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.configuration.common;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.io.PrintWriter;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.Configuration;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.StringFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.constraints.PortConstraint;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringNotNullFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToIntegerFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToLevelFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;

public final class ClientConfiguration
extends Configuration {
    public static final String LOGLEVEL = "loglevel";
    private final ConfigurationOption<Level> logLevel = new DefaultConfigurationOption<Level>("loglevel", "Sets the log level.", "(" + Joiner.on("|").join(Logger.POSSIBLE_SETTINGS) + ")", Level.FINE, new StringToLevelFunction(), "logLevel");
    public static final String MASTER = "connectionBuilderHost";
    private static final String MASTER__OPTIOAN_NAME = "master";
    private final ConfigurationOption<String> master = new DefaultConfigurationOption<String>("master", "Sets the hostname of the master to connect to.", "<hostname>", "localhost", new StringNotNullFunction(), "connectionBuilderHost");
    public static final String MASTER_PORT_ENV_VAR = "VCLOUD_MASTER_PORT";
    public static final String MASTER_PORT = "master-port";
    private final ConfigurationOption<Integer> masterPort = new DefaultConfigurationOption<Integer>("master-port", "Sets the port number at the master used by the client to connect to the master.", "<port>", Integer.valueOf(15140), (StringFunction<Integer>)new StringToIntegerFunction(), (Predicate<Integer>)new PortConstraint(), "connectionBuilderPort");
    private final ImmutableSet<ConfigurationOption<?>> options = ImmutableSet.of(this.logLevel, this.master, this.masterPort);

    public Level getLogLevel() {
        return this.logLevel.getValue();
    }

    public String getMasterHostName() {
        return this.master.getValue();
    }

    public void overriedMasterPort(String value) throws InvalidOptionException {
        this.masterPort.setValue(value);
    }

    @Override
    public ImmutableSet<ConfigurationOption<?>> getAllConfigurationOptions() {
        return this.options;
    }

    public static ImmutableSet<ConfigurationOption<?>> getConfigurationOptions() {
        return new ClientConfiguration().getAllConfigurationOptions();
    }

    @Override
    public void write(PrintWriter writer) {
        writer.println("# This is the general client configuration.\n# There are additional files for some clients that\n# contain the specific configuration.");
        writer.println();
        super.write(writer);
    }

    public static DefaultConfigurationBuilder<ClientConfiguration> getDefaultConfigurationBuilder() {
        return new DefaultConfigurationBuilder<ClientConfiguration>(){

            @Override
            public ClientConfiguration getDefaultConfiguration() {
                return new ClientConfiguration();
            }
        };
    }

    public static String getOptions() {
        return ClientConfiguration.buildOptionsString(ClientConfiguration.getConfigurationOptions());
    }
}

