/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.configuration.cpachecker;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.TypeLiteral;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.Configuration;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.GenericTypeConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.constraints.GlobPatternConstraint;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.constraints.PositiveIntegerConstraint;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringNotNullFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToBooleanFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToImmutableListeFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToImmutableSetFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToIntegerFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToMemoryUnitFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToOptionalFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToPathFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToSchedulingPriorityFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToTimeIntervalFunction;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class CPAcheckerConfiguration
extends Configuration {
    public static final String CPA_CHECKER_DIR = "cpachecker-dir";
    private final ConfigurationOption<Path> cpaCheckerDir = new DefaultConfigurationOption<Path>("cpachecker-dir", "Sets the path to the CPAchecker base directory.", "path/to/cpaChecker", Paths.get(".", new String[0]), new StringToPathFunction(), Path.class);
    public static final String OUTPUT_DIR = "output-dir";
    private final ConfigurationOption<Optional<Path>> outputDir = new GenericTypeConfigurationOption<Optional<Path>>("output-dir", "Target directory for files produced by CPAchecker run.If absent, value of " + this.cpaCheckerDir.getName() + "is used.", "- | path/to/directory", Optional.absent(), new StringToOptionalFunction<Path>(new StringToPathFunction()), new TypeLiteral<Optional<Path>>(){});
    public static final String INPUT_FILE = "input";
    private final ConfigurationOption<Path> inputFile = new DefaultConfigurationOption<Path>("input", "Sets the input file for CPAchecker.", "path/to/input-file.c", Paths.get(".", new String[0]), new StringToPathFunction(), Path.class);
    public static final String REQUIRED_FILES = "requiredFiles";
    private final ConfigurationOption<ImmutableSet<String>> requiredFiles = new GenericTypeConfigurationOption<ImmutableSet<String>>("requiredFiles", "Comma separated list of paths to files and directories required for CPAchecker execution.", "[program1,program2,...]", ImmutableSet.of("cpachecker.jar", "config", "lib", "scripts"), new StringToImmutableSetFunction<String>(new StringNotNullFunction(), ","), new TypeLiteral<ImmutableSet<String>>(){});
    public static final String TIME_LIMITATION = "timeLimitation";
    private final ConfigurationOption<TimeInterval> timeLimitation = new DefaultConfigurationOption<TimeInterval>("timeLimitation", "Time limitation. Will try to interprete input. If no units are given, seconds are assumed.", "[1d] [1h] [1min] 1[s]", TimeInterval.minutes(30L), new StringToTimeIntervalFunction(), TimeInterval.class);
    public static final String MEMORY = "memory-requirement-limitation";
    private final ConfigurationOption<MemoryUnit> memoryRequirementLimitation = new DefaultConfigurationOption<MemoryUnit>("memory-requirement-limitation", "Memory available to the run.", "[0-9]+ [KMG]", MemoryUnit.gigabyte(1L), new StringToMemoryUnitFunction(), MemoryUnit.class);
    public static final String CORES = "cores-requirement-limitation";
    private final ConfigurationOption<Integer> coresRequirementLimitation = new DefaultConfigurationOption<Integer>("cores-requirement-limitation", "Number of cores available to the run.", "[1-9][0-9]*", Integer.valueOf(1), new StringToIntegerFunction(), new PositiveIntegerConstraint());
    public static final String CPU_MODEL = "cpu-model";
    private final ConfigurationOption<ImmutableList<String>> cpuModel = new GenericTypeConfigurationOption<ImmutableList<String>>("cpu-model", "Part of the CPU model required to execute this Run or empty, if no specific CPU model is required. Format is a comma seperated list.", "[cpuModel1,cpuModel2,...]", ImmutableList.of(), new StringToImmutableListeFunction<String>(new StringNotNullFunction(), ","), new TypeLiteral<ImmutableList<String>>(){});
    public static final String RESULT_FILE_PATTERN = "resultFilePattern";
    private final ConfigurationOption<String> resultFilePattern = new DefaultConfigurationOption<String>("resultFilePattern", "Glob pattern of resul files that should be transported back to the client.", "pattern", "**", new StringNotNullFunction(), new GlobPatternConstraint());
    public static final String USERNAME = "username";
    private final ConfigurationOption<Optional<String>> username = new GenericTypeConfigurationOption<Optional<String>>("username", "Give a specific username to amend the default username. May be omitted.", "-", Optional.absent(), new StringToOptionalFunction<String>(new StringNotNullFunction()), new TypeLiteral<Optional<String>>(){});
    public static final String PRIORITY = "priority";
    private final ConfigurationOption<SchedulingPriority> priority = new DefaultConfigurationOption<SchedulingPriority>("priority", "The priority of the run.", Joiner.on(" | ").join((Object[])SchedulingPriority.values()), SchedulingPriority.LOW, new StringToSchedulingPriorityFunction());
    public static final String DETACH = "detach";
    private final ConfigurationOption<Boolean> detach = new DefaultConfigurationOption<Boolean>("detach", "Only sumbit verification task and do not wait for result.", "true | false", false, new StringToBooleanFunction());
    private final ImmutableSet<ConfigurationOption<?>> options = ImmutableSet.of(this.cpaCheckerDir, this.outputDir, this.inputFile, this.requiredFiles, this.priority, this.timeLimitation, new ConfigurationOption[]{this.memoryRequirementLimitation, this.coresRequirementLimitation, this.cpuModel, this.resultFilePattern, this.username, this.detach});

    @Override
    public ImmutableSet<ConfigurationOption<?>> getAllConfigurationOptions() {
        return this.options;
    }

    public static ImmutableSet<ConfigurationOption<?>> getConfigurationOptions() {
        return new CPAcheckerConfiguration().getAllConfigurationOptions();
    }

    @Override
    public void write(PrintWriter writer) {
        writer.println("# The general client configuration file is Config. This is the CPAchecker client specific configuration:");
        writer.println();
        super.write(writer);
    }

    public static DefaultConfigurationBuilder<CPAcheckerConfiguration> getDefaultConfigurationBuilder() {
        return new DefaultConfigurationBuilder<CPAcheckerConfiguration>(){

            @Override
            public CPAcheckerConfiguration getDefaultConfiguration() {
                return new CPAcheckerConfiguration();
            }
        };
    }

    public static String getOptions() {
        return CPAcheckerConfiguration.buildOptionsString(CPAcheckerConfiguration.getConfigurationOptions());
    }
}

