/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.configuration.infoclient;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.inject.TypeLiteral;
import java.io.PrintWriter;
import java.nio.file.Path;
import org.sosy_lab.verifiercloud.client.applications.infoclient.formatting.InfoClientOutputFormat;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.Configuration;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.GenericTypeConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToInfoClientoutputFormatFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToOptionalFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToPathFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToTimeIntervalFunction;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class InfoClientConfiguration
extends Configuration {
    public static final String FORMAT = "format";
    private final ConfigurationOption<InfoClientOutputFormat> format = new DefaultConfigurationOption<InfoClientOutputFormat>("format", "Sets the desired output format. Defaults to plaintext.", Joiner.on(" | ").join((Object[])InfoClientOutputFormat.values()), InfoClientOutputFormat.PLAIN, new StringToInfoClientoutputFormatFunction(), InfoClientOutputFormat.class);
    public static final String OUTPUT = "output";
    private final ConfigurationOption<Optional<Path>> output = new GenericTypeConfigurationOption<Optional<Path>>("output", "Sets the output path. If value is '-' (default), output is written to standard out.", "- | <path>", Optional.absent(), new StringToOptionalFunction<Path>(new StringToPathFunction()), new TypeLiteral<Optional<Path>>(){});
    public static final String REPETITION_INTERVAL = "interval";
    private final ConfigurationOption<Optional<TimeInterval>> repetitionInterval = new GenericTypeConfigurationOption<Optional<TimeInterval>>("interval", "Sets the time interval (in seconds) between repetitions of the output. If the interval given is invalid or < 1, the client terminates after one output.", "[0 | <interval>]", Optional.absent(), new StringToOptionalFunction<TimeInterval>(new StringToTimeIntervalFunction(), "0"), new TypeLiteral<Optional<TimeInterval>>(){});
    private final ImmutableSet<ConfigurationOption<?>> options = ImmutableSet.of(this.format, this.output, this.repetitionInterval);

    @Override
    public ImmutableSet<ConfigurationOption<?>> getAllConfigurationOptions() {
        return this.options;
    }

    public static ImmutableSet<ConfigurationOption<?>> getConfigurationOptions() {
        return new InfoClientConfiguration().getAllConfigurationOptions();
    }

    @Override
    public void write(PrintWriter writer) {
        writer.println("# The general client configuration file is Config. This is the InfoClient specific configuration:");
        writer.println();
        super.write(writer);
    }

    public static DefaultConfigurationBuilder<InfoClientConfiguration> getDefaultConfigurationBuilder() {
        return new DefaultConfigurationBuilder<InfoClientConfiguration>(){

            @Override
            public InfoClientConfiguration getDefaultConfiguration() {
                return new InfoClientConfiguration();
            }
        };
    }

    public static String getOptions() {
        return InfoClientConfiguration.buildOptionsString(InfoClientConfiguration.getConfigurationOptions());
    }
}

