/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.configuration.webclient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.TypeLiteral;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnBranchHead;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevisionPattern;
import org.sosy_lab.verifiercloud.global.Constants;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.Configuration;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.GenericTypeConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.constraints.GlobPatternConstraint;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.constraints.MapNotEmptyConstraint;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.constraints.PositiveIntegerConstraint;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.constraints.RegexPatternConstraint;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.constraints.SetConstraint;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringNotNullFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToBooleanFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToImmutableListeFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToImmutableMapFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToImmutableSetFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToIntegerFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToLevelFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToLimitationsFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToMemoryUnitFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToOptionalFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToPathFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToSchedulingPriorityFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToSvnRevisionPatternFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToTimeIntervalFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToUriFunction;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.LimitationsBuilder;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class WebClientConfiguration
extends Configuration {
    public static final String URL = "url";
    private final ConfigurationOption<Optional<URI>> url = new GenericTypeConfigurationOption<Optional<URI>>("url", "The base url of the webclient. It is used to generate the generl help text page.If not set, it will be determined from the request URL.", "(-| URL)", Optional.absent(), new StringToOptionalFunction<URI>(new StringToUriFunction()), new TypeLiteral<Optional<URI>>(){});
    public static final String STATIC_CONTENT_URL = "staticContentUrl";
    private final ConfigurationOption<Optional<URI>> staticContentUrl = new GenericTypeConfigurationOption<Optional<URI>>("staticContentUrl", "The base url of the static content.If not set, it will be determined from the request URL.", "(-| URL)", Optional.absent(), new StringToOptionalFunction<URI>(new StringToUriFunction()), new TypeLiteral<Optional<URI>>(){});
    public static final String LOCAL_PATH = "local-path";
    private final ConfigurationOption<Path> localPath = new DefaultConfigurationOption<Path>("local-path", "Sets the path where the web client stores files.", "<path>", Paths.get(Constants.DEFAULT_WEB_CLIENT_WORKING_FOLDER, new String[0]), new StringToPathFunction(), Path.class);
    public static final String FILE_LOGLEVEL = "file-loglevel";
    private final ConfigurationOption<Level> fileLoglevel = new DefaultConfigurationOption<Level>("file-loglevel", "Sets the log level for logging to a file. Does not log to file if set to OFF.", "(" + Joiner.on("|").join(Logger.POSSIBLE_SETTINGS) + ")", Level.OFF, new StringToLevelFunction());
    public static final String FILE_LOG_PATH = "file-log-path";
    private final ConfigurationOption<Path> fileLogPath = new DefaultConfigurationOption<Path>("file-log-path", "Sets the path of a directory where log files are stored.", "<path>", Paths.get("logfiles", new String[0]), new StringToPathFunction(), Path.class);
    public static final String COMPRESSED_FILE_LOGIN = "compressed-file-logging";
    private final ConfigurationOption<Boolean> compressedFileLogging = new DefaultConfigurationOption<Boolean>("compressed-file-logging", "Sets whether the log file is compressed or not.", "(true | false)", false, new StringToBooleanFunction());
    public static final String GIT_REPOSITORY = "gitRepository";
    private final ConfigurationOption<Path> gitRepository = new DefaultConfigurationOption<Path>("gitRepository", "The path to the git repository of the programm to be executed by the webclient.", "path/to/git/repository", Paths.get("git/cpachecker", new String[0]), new StringToPathFunction(), Path.class);
    public static final String GIT_REPOSITORY_AUTO_FETCH = "gitRepositoryAutoFetch";
    private final ConfigurationOption<Boolean> gitRepositoryAutoFetch = new DefaultConfigurationOption<Boolean>("gitRepositoryAutoFetch", "If set to true the web client fetches new revisions automatically. If set to false this process musst be triggered. Default is true", "(true | false)", Boolean.valueOf(true), new StringToBooleanFunction(), Boolean.class);
    public static final String GIT_FETCH_COMMAND = "gitFetchCommand";
    private final ConfigurationOption<String> gitFetchCommand = new DefaultConfigurationOption<String>("gitFetchCommand", "The command used to fetch new revisions from the svn repository into the local git repository. Default is 'git svn fetch'", "<command>", "git svn fetch", new StringNotNullFunction());
    private static final ImmutableSet<String> CPA_CHECKER_PATHS_PATTERNS = ImmutableSet.of("config", "lib/native/*linux*", "lib/*.*", "scripts");
    public static final String REQUIRED_FILE_PATTERNS = "requiredFilePatterns";
    private final ConfigurationOption<ImmutableSet<String>> requiredFilePatterns = new GenericTypeConfigurationOption<ImmutableSet<String>>("requiredFilePatterns", "Comma separated list of paths to files and directories relative to the bath path of the repository required to execute the tool. Glob patterns can be used. For files created by the build command use buildCommandResultFiles. Default is configuration for CPAchecker. All allowed config files and the default spec file must be part of this options or buildCommandResultFiles.", "[path1,path2,...]", CPA_CHECKER_PATHS_PATTERNS, new StringToImmutableSetFunction<String>(new StringNotNullFunction(), ","), new SetConstraint<String>(new GlobPatternConstraint()), new TypeLiteral<ImmutableSet<String>>(){});
    public static final String COMMAND = "command";
    private final ConfigurationOption<ImmutableList<String>> command = new GenericTypeConfigurationOption<ImmutableList<String>>("command", "Sets the path to the program/script that should be called.", "path/to/program", ImmutableList.of("scripts/cpa.sh", "-secureMode"), new StringToImmutableListeFunction<String>(new StringNotNullFunction(), " "), new TypeLiteral<ImmutableList<String>>(){});
    public static final String ALLOWED_REVISIONS_AND_BRANCHES = "allowedRevisionsAndBranches";
    private final ConfigurationOption<ImmutableSet<SvnRevisionPattern>> allowedRevisionsAndBranches = new GenericTypeConfigurationOption<ImmutableSet<SvnRevisionPattern>>("allowedRevisionsAndBranches", "Comma separated list of tags and tupels of a svn branch and revision number of the tool allowed to be executed by the web client. The branch can also be the trunk and 'HEAD' is a possible options for the revision number. If the revision number is '*'all revisions of this branch are allowed.", "[tag1,branch1:rev1,branch2:rev2,tag2,...]", ImmutableSet.of(new SvnBranchHead("trunk")), new StringToImmutableSetFunction<SvnRevisionPattern>(new StringToSvnRevisionPatternFunction(), ","), new TypeLiteral<ImmutableSet<SvnRevisionPattern>>(){});
    public static final String ALLOWED_OPTIONS = "allowedOptions";
    private final ConfigurationOption<ImmutableSet<String>> allowedOptions = new GenericTypeConfigurationOption<ImmutableSet<String>>("allowedOptions", "White listed properties that can not cause security problems.", "[prop1,prop2,...]", ImmutableSet.of(), new StringToImmutableSetFunction<String>(new StringNotNullFunction(), ","), new TypeLiteral<ImmutableSet<String>>(){});
    @VisibleForTesting
    public static final String DEFAULT_CONFIG_FILES_PATTERN = "^[a-zA-Z0-9-+]+$";
    public static final String CONFIG_SPEC_PATTERN = "configAndSpecPattern";
    private final ConfigurationOption<String> configAndSpecPattern = new DefaultConfigurationOption<String>("configAndSpecPattern", "Regular expression of allowed configurations and specifications.Default is ^[a-zA-Z0-9-+]+$.", "[regular expression]", "^[a-zA-Z0-9-+]+$", new StringNotNullFunction(), new RegexPatternConstraint());
    public static final String DISALLOWED_SPEC_CONFIG = "disallowedSpecAndConfig";
    private final ConfigurationOption<ImmutableSet<String>> disallowedSpecAndConfig = new GenericTypeConfigurationOption<ImmutableSet<String>>("disallowedSpecAndConfig", "Black listed strings that musst not be used as configuration or specification names because of security problems. Default is 'setprop', 'config'.", "[name1,name2,...]", ImmutableSet.of("setprop", "config"), new StringToImmutableSetFunction<String>(new StringNotNullFunction(), ","), new TypeLiteral<ImmutableSet<String>>(){});
    public static final String NORMAL_PRIORITY = "normalPriority";
    private final ConfigurationOption<SchedulingPriority> normalPriority = new DefaultConfigurationOption<SchedulingPriority>("normalPriority", "The normal scheduling priority of runs submitted by the web client.Default is " + (Object)((Object)SchedulingPriority.IDLE) + ".", Joiner.on(" | ").join((Object[])SchedulingPriority.values()), SchedulingPriority.IDLE, new StringToSchedulingPriorityFunction());
    public static final String PREMIUM_PRIORITY = "premiumPriority";
    private final ConfigurationOption<SchedulingPriority> premiumPriority = new DefaultConfigurationOption<SchedulingPriority>("premiumPriority", "The permium scheduling priority of runs submitted by the web client.Default is " + (Object)((Object)SchedulingPriority.LOW) + ".", Joiner.on(" | ").join((Object[])SchedulingPriority.values()), SchedulingPriority.LOW, new StringToSchedulingPriorityFunction());
    private static final ImmutableMap<String, Limitations> defaultPreDefinedLimitations = ImmutableMap.of("low", LimitationsBuilder.from(TimeInterval.minutes(5L)).setMemoryLimit(MemoryUnit.gigabyte(2L)).setCoreLimit(2).build(), "medium", LimitationsBuilder.from(TimeInterval.minutes(10L)).setMemoryLimit(MemoryUnit.gigabyte(7L)).setCoreLimit(2).build(), "high", LimitationsBuilder.from(TimeInterval.minutes(15L)).setMemoryLimit(MemoryUnit.gigabyte(15L)).setCoreLimit(2).build());
    public static final String PRE_DEFINED_LIMITATIONS = "preDefinedLimitations";
    private final ConfigurationOption<ImmutableMap<String, Limitations>> preDefinedLimitations = new GenericTypeConfigurationOption<ImmutableMap<String, Limitations>>("preDefinedLimitations", "Non empty comma separated list of pairs of name and limitations. Limitations are a tupel of time limitation, memory limitaion and core limitation e.g low=(120s,512MB,2). Will try to interprete input. If no units are given, seconds and bytes are assumed.The first given limitations is the default. All values should not be greater than the maximum allowed limiations.", "[name1=(time1, memory1, core1), name2=(time2, memory2, core2)...]", defaultPreDefinedLimitations, new StringToImmutableMapFunction<String, Limitations>(new StringNotNullFunction(), new StringToLimitationsFunction()), new MapNotEmptyConstraint(), new TypeLiteral<ImmutableMap<String, Limitations>>(){});
    public static final String TIME_LIMITATION = "timeLimitation";
    private final ConfigurationOption<TimeInterval> timeLimitation = new DefaultConfigurationOption<TimeInterval>("timeLimitation", "Maximum time limitation. Will try to interprete input. If no units are given, seconds are assumed.Users of the web client cmay set a lower limit.", "[1d] [1h] [1min] 1[s]", TimeInterval.minutes(25L), new StringToTimeIntervalFunction());
    public static final String MEMORY_LIMITATION = "memoryRequirementLimitation";
    private final ConfigurationOption<MemoryUnit> memoryRequirementLimitation = new DefaultConfigurationOption<MemoryUnit>("memoryRequirementLimitation", "Maximum memory available to the run.Users of the web client cmay set a lower limit.", "[0-9]+ [KMG]", MemoryUnit.gigabyte(15L), new StringToMemoryUnitFunction(), MemoryUnit.class);
    public static final String CORE_LIMITATION = "coresRequirementLimitation";
    private final ConfigurationOption<Integer> coresRequirementLimitation = new DefaultConfigurationOption<Integer>("coresRequirementLimitation", "Maximum number of cores available to runs. Users of the web client cmay set a lower limit.", "[1-9][0-9]*", Integer.valueOf(8), new StringToIntegerFunction(), new PositiveIntegerConstraint());
    public static final String BUILD_COMMAND = "buildCommand";
    private final ConfigurationOption<Optional<ImmutableList<String>>> buildCommand = new GenericTypeConfigurationOption<Optional<ImmutableList<String>>>("buildCommand", "Sets the optional command that builds the tool. The used program musst be available on the workers. ${revision} is replaced with the revision number.Default is ant 'jar -Dversion.revision=${revision}'.", "[build command | -]", Optional.of(ImmutableList.of("ant", "jar", "-Dversion.revision=${revision}")), new StringToOptionalFunction<String>(new StringToImmutableListeFunction<String>(new StringNotNullFunction(), " ")), new TypeLiteral<Optional<ImmutableList<String>>>(){});
    private static final ImmutableSet<String> CPA_CHECKER_BUILD_PATH_PATTERNS = ImmutableSet.of("src", "lib/*.jar", "lib/*.xml", "build", "build.xml");
    public static final String BUILD_COMMAND_REQUIRED_FILE_PATTERNS = "buildCommandrequiredFilePatterns";
    private final ConfigurationOption<ImmutableSet<String>> buildCommandrequiredFilePatterns = new GenericTypeConfigurationOption<ImmutableSet<String>>("buildCommandrequiredFilePatterns", "Comma separated list of paths to  files and directories relative to the bath path of the repository required to build the tool.Default is configuration for CPAchecker.", "[path1,path2,...]", CPA_CHECKER_BUILD_PATH_PATTERNS, new StringToImmutableSetFunction<String>(new StringNotNullFunction(), ","), new SetConstraint<String>(new GlobPatternConstraint()), new TypeLiteral<ImmutableSet<String>>(){});
    public static final String BUILD_COMMAND_RESULT_FILES = "buildCommandResultFiles";
    private final ConfigurationOption<ImmutableSet<String>> buildCommandResultFiles = new GenericTypeConfigurationOption<ImmutableSet<String>>("buildCommandResultFiles", "Sets the result paths of the build command. This files are available to runs started by the web client.Glob patterns are allowed.Ignored if no build command is set.All allowed config files and the default spec file must be part of this options or requiredFilePatterns.", "[path1,path2,..]", ImmutableSet.of("cpachecker.jar", "lib/java/runtime/*"), new StringToImmutableSetFunction<String>(new StringNotNullFunction(), ","), new SetConstraint<String>(new GlobPatternConstraint()), new TypeLiteral<ImmutableSet<String>>(){});
    public static final String BUILD_COMMAND_TIME_LIMITATION = "buildCommandTimeLimitation";
    private final ConfigurationOption<TimeInterval> buildCommandTimeLimitation = new DefaultConfigurationOption<TimeInterval>("buildCommandTimeLimitation", "Time limitation of build runs. Will try to interprete input. If no units are given, seconds are assumed.", "[1d] [1h] [1min] 1[s]", TimeInterval.minutes(5L), new StringToTimeIntervalFunction(), TimeInterval.class);
    public static final String BUILD_COMMAND_MEMORY_LIMITATION = "buildCommandMemoryRequirementLimitation";
    private final ConfigurationOption<MemoryUnit> buildCommandMemoryRequirementLimitation = new DefaultConfigurationOption<MemoryUnit>("buildCommandMemoryRequirementLimitation", "Maximum memory available to build runs.", "[0-9]+ [KMG]", MemoryUnit.gigabyte(1L), new StringToMemoryUnitFunction(), MemoryUnit.class);
    public static final String BUILD_COMMAND_CORE_LIMITATION = "buildCommandCoresLimitation";
    private final ConfigurationOption<Integer> buildCommandCoresRequirementLimitation = new DefaultConfigurationOption<Integer>("buildCommandCoresLimitation", "Maximum number of cores available to build runs. ", "[1-9][0-9]*", Integer.valueOf(2), new StringToIntegerFunction(), new PositiveIntegerConstraint());
    public static final String BUILD_COMMAND_CPU_MODELS = "buildCommandCpuModels";
    private final ConfigurationOption<ImmutableList<String>> buildCommandCpuModels = new GenericTypeConfigurationOption<ImmutableList<String>>("buildCommandCpuModels", "Parts of CPU models names required to execute build runs or empty, if no specific CPU model is required.", "cpu1,cpu2,cpu3,...", ImmutableList.of(), new StringToImmutableListeFunction<String>(new StringNotNullFunction(), ","), new TypeLiteral<ImmutableList<String>>(){});
    public static final String BUILD_COMMAND_SCHEDULING_PRIORITY = "buildCommandSchedulingPriority";
    private final ConfigurationOption<SchedulingPriority> buildCommandSchedulingPriority = new DefaultConfigurationOption<SchedulingPriority>("buildCommandSchedulingPriority", "The scheduling priority of build commands.Default is " + (Object)((Object)SchedulingPriority.HIGH) + ".", Joiner.on(" | ").join((Object[])SchedulingPriority.values()), SchedulingPriority.HIGH, new StringToSchedulingPriorityFunction());
    public static final String MASTER_INFO_REFRESH_INTERVAL = "masterInfoRefreshInterval";
    private final ConfigurationOption<TimeInterval> masterInfoRefreshInterval = new DefaultConfigurationOption<TimeInterval>("masterInfoRefreshInterval", "The refresh intercal of the master information HTML page. Will try to interprete input. If no units are given, seconds are assumed.", "[1d] [1h] [1min] 1[s]", TimeInterval.seconds(5L), new StringToTimeIntervalFunction());
    public static final String RUN_STATES_CACHE_VALIDITY = "runStatesCacheValidity";
    private final ConfigurationOption<TimeInterval> runStatesCacheValidity = new DefaultConfigurationOption<TimeInterval>("runStatesCacheValidity", "The maximum time cached run state values are valid.  If no units are given, seconds are assumed.", "[1d] [1h] [1min] 1[s]", TimeInterval.seconds(5L), new StringToTimeIntervalFunction());
    public static final String USERNAME = "username";
    private final ConfigurationOption<Optional<String>> username = new GenericTypeConfigurationOption<Optional<String>>("username", "Give a specific username to amend the default username. May be omitted.", "<username> | -", Optional.of("webclient"), new StringToOptionalFunction<String>(new StringNotNullFunction()), new TypeLiteral<Optional<String>>(){});
    public static final String ERROR_TRIGGER_COMMAND = "error-trigger-command";
    private final ConfigurationOption<Optional<String>> errorTriggerCommand = new GenericTypeConfigurationOption<Optional<String>>("error-trigger-command", "Command beeing executed in case of an exception or dead lock.", "- | <command>", Optional.absent(), new StringToOptionalFunction<String>(new StringNotNullFunction()), new TypeLiteral<Optional<String>>(){});

    @Override
    public ImmutableSet<ConfigurationOption<?>> getAllConfigurationOptions() {
        return ImmutableSet.of(this.url, this.staticContentUrl, this.localPath, this.fileLoglevel, this.fileLogPath, this.compressedFileLogging, new ConfigurationOption[]{this.gitRepository, this.gitRepositoryAutoFetch, this.gitFetchCommand, this.requiredFilePatterns, this.command, this.allowedRevisionsAndBranches, this.allowedOptions, this.configAndSpecPattern, this.disallowedSpecAndConfig, this.normalPriority, this.premiumPriority, this.preDefinedLimitations, this.timeLimitation, this.memoryRequirementLimitation, this.coresRequirementLimitation, this.buildCommand, this.buildCommandrequiredFilePatterns, this.buildCommandResultFiles, this.buildCommandTimeLimitation, this.buildCommandMemoryRequirementLimitation, this.buildCommandCoresRequirementLimitation, this.buildCommandCpuModels, this.buildCommandSchedulingPriority, this.masterInfoRefreshInterval, this.runStatesCacheValidity, this.username, this.errorTriggerCommand});
    }

    public Path getLocalPath() {
        return this.localPath.getValue();
    }

    public Level getFileLogLevel() {
        return this.fileLoglevel.getValue();
    }

    public Path getFileLogPath() {
        return this.fileLogPath.getValue();
    }

    public boolean isLogFileCompressed() {
        return this.compressedFileLogging.getValue();
    }

    public Optional<String> getErrorTriggerCommand() {
        return this.errorTriggerCommand.getValue();
    }

    @Override
    public void write(PrintWriter writer) {
        writer.println("# The general client configuration file is Config. This is the WebClient specific configuration:");
        writer.println();
        super.write(writer);
    }

    public static DefaultConfigurationBuilder<WebClientConfiguration> getDefaultConfigurationBuilder() {
        return new DefaultConfigurationBuilder<WebClientConfiguration>(){

            @Override
            public WebClientConfiguration getDefaultConfiguration() {
                return new WebClientConfiguration();
            }
        };
    }
}

