/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.files;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.global.file_storage.FileUnknownException;
import org.sosy_lab.verifiercloud.global.logging.LoggerBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.util.FileUtils;
import org.sosy_lab.verifiercloud.transportable.filecontent.DefaultFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;

public abstract class ClientFileStorageTestBase {
    private Path tempDir;

    protected abstract ClientFileStorage getClientFileStorageInstance() throws IOException, PermanentStorageException;

    @Before
    public void setUp() throws Exception {
        this.tempDir = Files.createTempDirectory("vcloud-test-ClientFileStorageTestBase", new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.isDirectory(this.tempDir, new LinkOption[0]));
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory(this.tempDir, LoggerBuilder.create().build());
    }

    @Test
    public void testAdd() throws Exception {
        DefaultFileContent fileContent = DefaultFileContent.fromBytes("some content".getBytes(Charsets.UTF_8));
        Path filePath = this.tempDir.resolve("testfile");
        fileContent.writeToPath(filePath);
        Preconditions.checkState(Files.exists(filePath, new LinkOption[0]));
        ClientFileStorage testStorage = this.getClientFileStorageInstance();
        HashCode returnedFileHash = testStorage.pushFile(filePath);
        Assert.assertEquals((Object)fileContent.getFileHash(), (Object)returnedFileHash);
    }

    @Test
    public void testAddAndRemoveGet() throws Exception {
        DefaultFileContent fileContent = DefaultFileContent.fromBytes("some content".getBytes(Charsets.UTF_8));
        Path filePath = this.tempDir.resolve("testfile");
        fileContent.writeToPath(filePath);
        Preconditions.checkState(Files.exists(filePath, new LinkOption[0]));
        ClientFileStorage testStorage = this.getClientFileStorageInstance();
        HashCode returnedFileHash = testStorage.pushFile(filePath);
        FileContent returnedFile = testStorage.getAndRemoveFile(returnedFileHash);
        Assert.assertEquals((Object)fileContent, (Object)returnedFile);
        Assert.assertFalse((boolean)testStorage.isFileKnown(returnedFileHash));
    }

    @Test
    public void testGet() throws Exception {
        DefaultFileContent fileContent = DefaultFileContent.fromBytes("some content".getBytes(Charsets.UTF_8));
        Path filePath = this.tempDir.resolve("testfile");
        fileContent.writeToPath(filePath);
        Preconditions.checkState(Files.exists(filePath, new LinkOption[0]));
        ClientFileStorage testStorage = this.getClientFileStorageInstance();
        HashCode returnedFileHash = testStorage.pushFile(filePath);
        FileContent returnedFile = testStorage.getFile(returnedFileHash);
        Assert.assertEquals((Object)fileContent, (Object)returnedFile);
        Assert.assertTrue((boolean)testStorage.isFileKnown(returnedFileHash));
    }

    @Test(expected=FileUnknownException.class)
    public void testRemoveAndGet() throws Exception {
        DefaultFileContent fileContent = DefaultFileContent.fromBytes("some content".getBytes(Charsets.UTF_8));
        Path filePath = this.tempDir.resolve("testfile");
        fileContent.writeToPath(filePath);
        Preconditions.checkState(Files.exists(filePath, new LinkOption[0]));
        ClientFileStorage testStorage = this.getClientFileStorageInstance();
        HashCode returnedFileHash = testStorage.pushFile(filePath);
        testStorage.removeFile(returnedFileHash);
        testStorage.getAndRemoveFile(returnedFileHash);
    }

    @Test(expected=FileUnknownException.class)
    public void testRemoveFailure() throws Exception {
        DefaultFileContent unaddedFile = DefaultFileContent.fromBytes("content".getBytes(Charsets.UTF_8));
        this.getClientFileStorageInstance().getAndRemoveFile(unaddedFile.getFileHash());
    }

    @Test(expected=IOException.class)
    public void testFileNotFoundException() throws Exception {
        Path fileNotInExistance = this.tempDir.resolve("does_not_exist");
        Preconditions.checkState(!Files.exists(fileNotInExistance, new LinkOption[0]));
        this.getClientFileStorageInstance().pushFile(fileNotInExistance);
    }
}

