/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.files;

import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.global.file_storage.FileUnknownException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.util.HashUtils;
import org.sosy_lab.verifiercloud.transportable.filecontent.EmptyFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;

public class DummyClientFileStorage
implements ClientFileStorage {
    private final Map<HashCode, FileContent> files;

    public DummyClientFileStorage() {
        this.files = Maps.newHashMap();
    }

    public DummyClientFileStorage(Map<HashCode, FileContent> files) {
        this.files = files;
    }

    @Override
    public HashCode pushFile(Path file) throws FileNotFoundException, IOException {
        return HashUtils.hashFile(file);
    }

    @Override
    public boolean isFileKnown(HashCode fileHash) {
        return this.files.containsKey(fileHash);
    }

    @Override
    public FileContent getFile(HashCode fileHash) throws FileUnknownException {
        if (this.isFileKnown(fileHash)) {
            return this.files.get(fileHash);
        }
        return new EmptyFileContent();
    }

    @Override
    public FileContent getAndRemoveFile(HashCode fileHash) throws FileUnknownException {
        if (this.isFileKnown(fileHash)) {
            return this.files.remove(fileHash);
        }
        return new EmptyFileContent();
    }

    @Override
    public void initialize() throws PermanentStorageException {
    }

    @Override
    public void removeFile(HashCode fileHash) {
        this.files.remove(fileHash);
    }
}

