/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.files.hashcode_cache;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.nio.file.Path;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.DefaultPermanentStorage;
import org.sosy_lab.verifiercloud.global.permanent_storage.PermanentStorage;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;

public class CacheStorageProvider
implements Provider<PermanentStorage> {
    private final Logger logger;
    private final Path clientCacheStoragePath;

    @Inject
    public CacheStorageProvider(Logger logger, @Named(value="clientCacheStoragePath") Path clientCacheStoragePath) {
        this.logger = Preconditions.checkNotNull(logger);
        this.clientCacheStoragePath = Preconditions.checkNotNull(clientCacheStoragePath);
    }

    @Override
    public PermanentStorage get() {
        DefaultPermanentStorage permanentStorage = new DefaultPermanentStorage(this.clientCacheStoragePath, this.logger);
        try {
            permanentStorage.initialize();
        }
        catch (PermanentStorageException e) {
            throw new RuntimeException(e);
        }
        return permanentStorage;
    }
}

