/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.files.hashcode_cache;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.HashCodeCache;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.HashCodeCacheFileHandler;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.TimeStampHashCodePair;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.PermanentStorage;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;

public class DefaultHashCodeCache
implements HashCodeCache {
    private static final String HASH_CODE_CACHE_FILE = "hashCodeCache";
    private final HashCodeCacheFileHandler fileHandler;
    private final PermanentStorage permanentStorage;
    private final Map<Path, TimeStampHashCodePair> cachedHashCodes = Maps.newHashMap();

    @Inject
    public DefaultHashCodeCache(@Named(value="cacheStorage") PermanentStorage permanentStorage, Logger logger) {
        this.fileHandler = new HashCodeCacheFileHandler(logger);
        this.permanentStorage = permanentStorage;
    }

    @Override
    public synchronized void initialize() throws PermanentStorageException {
        this.permanentStorage.parseFile(HASH_CODE_CACHE_FILE, this.fileHandler);
        this.cachedHashCodes.putAll((Map<Path, TimeStampHashCodePair>)this.fileHandler.getParseResult());
    }

    @Override
    public synchronized boolean isHashCodeKnown(Path file) throws IOException {
        if (!this.cachedHashCodes.containsKey(Preconditions.checkNotNull(file))) {
            return false;
        }
        FileTime timestamp = this.cachedHashCodes.get(file).getTimestamp();
        return Files.getLastModifiedTime(file, new LinkOption[0]).equals(timestamp);
    }

    @Override
    public synchronized HashCode getHashCode(Path file) throws IOException {
        Preconditions.checkNotNull(file);
        Preconditions.checkArgument(this.isHashCodeKnown(file));
        return this.cachedHashCodes.get(file).getHashCode();
    }

    @Override
    public synchronized void addHashCode(Path file, FileTime timestamp, HashCode hashCode) {
        TimeStampHashCodePair timeStampHashCodePair = new TimeStampHashCodePair(timestamp, hashCode);
        this.cachedHashCodes.put(Preconditions.checkNotNull(file), timeStampHashCodePair);
    }

    @Override
    public synchronized void writeCache() throws IOException {
        try {
            this.permanentStorage.write(HASH_CODE_CACHE_FILE, this.cachedHashCodes, this.fileHandler);
        }
        catch (PermanentStorageException e) {
            throw new IOException("Cannot write the hashCode cache.", e);
        }
    }
}

