/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.files.hashcode_cache;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.HashCodeCache;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.TimeStampHashCodePair;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;

public class DummyHashCodeCache
implements HashCodeCache {
    private final Map<Path, TimeStampHashCodePair> cachedHashCodes = Maps.newHashMap();

    @Override
    public void initialize() throws PermanentStorageException {
    }

    @Override
    public boolean isHashCodeKnown(Path file) {
        return this.cachedHashCodes.containsKey(file);
    }

    @Override
    public HashCode getHashCode(Path file) {
        Preconditions.checkNotNull(file);
        Preconditions.checkArgument(this.isHashCodeKnown(file));
        return this.cachedHashCodes.get(file).getHashCode();
    }

    @Override
    public void addHashCode(Path file, FileTime timeStamp, HashCode hashCode) {
        this.cachedHashCodes.put(file, new TimeStampHashCodePair(timeStamp, hashCode));
    }

    @Override
    public void writeCache() throws IOException {
    }
}

