/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.files.hashcode_cache;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.bind.DatatypeConverter;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.TimeStampHashCodePair;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.StorageFileParser;

public class HashCodeCacheFileHandler
implements StorageFileParser<Map<Path, TimeStampHashCodePair>> {
    private static final char DELIMITER = '\t';
    private Map<Path, TimeStampHashCodePair> result = Maps.newHashMap();
    private Logger logger;

    public HashCodeCacheFileHandler(Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
    }

    @Override
    public void parse(CharSource source, String sourceName) throws IOException {
        HashCodeCacheLineProcessor lineProcessor = new HashCodeCacheLineProcessor();
        source.readLines(lineProcessor);
        this.result.putAll((Map<Path, TimeStampHashCodePair>)lineProcessor.getResult());
        if (!lineProcessor.success()) {
            this.logger.logf(Level.WARNING, "Hash code cache malformed.", new Object[0]);
        }
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.write(outputStream, this.result);
    }

    @Override
    public void write(OutputStream outputStream, Map<Path, TimeStampHashCodePair> cachedHashCodes) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream, Charsets.UTF_8));
        writer.println("#path\ttimestamp\thashCode");
        for (Map.Entry<Path, TimeStampHashCodePair> entry : cachedHashCodes.entrySet()) {
            Path path = entry.getKey();
            TimeStampHashCodePair timeStampHashCodePair = entry.getValue();
            writer.print(path.toString());
            writer.print('\t');
            writer.print(timeStampHashCodePair.getTimestamp().toMillis());
            writer.print('\t');
            writer.print(timeStampHashCodePair.getHashCode().toString());
            writer.println();
        }
        writer.flush();
    }

    @Override
    public Map<Path, TimeStampHashCodePair> getParseResult() {
        return this.result;
    }

    private static class HashCodeCacheLineProcessor
    implements LineProcessor<Map<Path, TimeStampHashCodePair>> {
        private static final Splitter SPLITTER = Splitter.on('\t').trimResults();
        private boolean success = true;
        private Map<Path, TimeStampHashCodePair> result = Maps.newHashMap();

        private HashCodeCacheLineProcessor() {
        }

        @Override
        public boolean processLine(String line) throws IOException {
            if (!line.startsWith("#") && !line.isEmpty()) {
                Iterator<String> tokens = SPLITTER.split(line).iterator();
                if (!tokens.hasNext()) {
                    this.success = false;
                    return true;
                }
                String token = tokens.next();
                Path path = Paths.get(token, new String[0]);
                if (!tokens.hasNext()) {
                    this.success = false;
                    return true;
                }
                String token2 = tokens.next();
                long milliSec = Long.parseLong(token2);
                FileTime timestamp = FileTime.fromMillis(milliSec);
                if (!tokens.hasNext()) {
                    this.success = false;
                    return true;
                }
                String token3 = tokens.next();
                byte[] hexToken = DatatypeConverter.parseHexBinary((String)token3);
                HashCode hashCode = HashCode.fromBytes(hexToken);
                this.result.put(path, new TimeStampHashCodePair(timestamp, hashCode));
            }
            return true;
        }

        @Override
        public Map<Path, TimeStampHashCodePair> getResult() {
            return this.result;
        }

        public boolean success() {
            return this.success;
        }
    }
}

