/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.files.hashcode_cache;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sosy_lab.verifiercloud.client.files.BackEndClientFileStorage;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.HashCodeCache;
import org.sosy_lab.verifiercloud.global.file_storage.FileUnknownException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;

public class HashCodeCacheFileStorage
implements ClientFileStorage {
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final HashCodeCache cache;
    private final BackEndClientFileStorage fileStorage;
    private final LoadingCache<HashCode, FileContent> fileCache;

    @Inject
    public HashCodeCacheFileStorage(HashCodeCache cache, BackEndClientFileStorage fileStorage) {
        this.cache = Preconditions.checkNotNull(cache);
        this.fileStorage = Preconditions.checkNotNull(fileStorage);
        this.fileCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<HashCode, FileContent>(){

            @Override
            public FileContent load(HashCode key) throws Exception {
                return HashCodeCacheFileStorage.this.fileStorage.getFile(key);
            }
        });
    }

    @Override
    public void initialize() throws PermanentStorageException, IOException {
        this.cache.initialize();
        this.fileStorage.initialize();
        this.initialized.set(true);
    }

    @Override
    public boolean isFileKnown(HashCode fileHash) {
        return this.fileStorage.isFileKnown(fileHash);
    }

    @Override
    public FileContent getFile(HashCode fileHash) throws FileUnknownException {
        FileContent fileContent;
        Preconditions.checkNotNull(fileHash);
        try {
            fileContent = this.fileCache.get(fileHash);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FileUnknownException) {
                throw (FileUnknownException)cause;
            }
            throw new RuntimeException(e.getCause());
        }
        return fileContent;
    }

    @Override
    public HashCode pushFile(Path file) throws IOException {
        HashCode fileHash;
        Preconditions.checkState(this.initialized.get(), "File storage is not initialized.");
        file = Preconditions.checkNotNull(file.toAbsolutePath());
        if (this.cache.isHashCodeKnown(file)) {
            fileHash = this.cache.getHashCode(file);
            this.fileStorage.pushFile(file, fileHash);
        } else {
            FileContent fileContent = this.fileStorage.pushFileAndGetFileContent(file);
            fileHash = fileContent.getFileHash();
            this.fileCache.put(fileHash, fileContent);
            this.cache.addHashCode(file, Files.getLastModifiedTime(file, new LinkOption[0]), fileHash);
        }
        return fileHash;
    }

    @Override
    public FileContent getAndRemoveFile(HashCode fileHash) throws FileUnknownException {
        FileContent fileContent;
        Preconditions.checkNotNull(fileHash);
        try {
            fileContent = this.fileCache.get(fileHash);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FileUnknownException) {
                throw (FileUnknownException)cause;
            }
            throw new RuntimeException(e.getCause());
        }
        finally {
            this.fileStorage.removeFile(fileHash);
        }
        this.fileCache.invalidate(fileHash);
        this.writeCacheIfEmpty();
        return fileContent;
    }

    @Override
    public void removeFile(HashCode fileHash) {
        this.fileStorage.removeFile(fileHash);
        this.writeCacheIfEmpty();
    }

    protected LoadingCache<HashCode, FileContent> getFileCache() {
        return this.fileCache;
    }

    public void cleanup() throws IOException {
        Preconditions.checkState(this.initialized.getAndSet(false));
        this.writeCache();
    }

    private void writeCacheIfEmpty() {
        if (this.fileStorage.isEmpty()) {
            this.writeCache();
        }
    }

    private void writeCache() {
        this.fileCache.invalidateAll();
        this.fileCache.cleanUp();
        try {
            this.cache.writeCache();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write hashcode cache.", e);
        }
    }
}

