/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.files.hashcode_cache;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.IOException;
import org.sosy_lab.verifiercloud.client.files.BackEndWebClientFileStorage;
import org.sosy_lab.verifiercloud.client.files.WebClientFileStorage;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.HashCodeCache;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.HashCodeCacheFileStorage;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;

public class HashCodeCacheWebClientFileStorage
extends HashCodeCacheFileStorage
implements WebClientFileStorage {
    private final BackEndWebClientFileStorage fileStorage;

    @Inject
    public HashCodeCacheWebClientFileStorage(HashCodeCache cache, BackEndWebClientFileStorage fileStorage) {
        super(cache, fileStorage);
        this.fileStorage = Preconditions.checkNotNull(fileStorage);
    }

    @Override
    public void pushFile(FileContent fileContent) throws IOException {
        this.getFileCache().put(fileContent.getFileHash(), fileContent);
        this.fileStorage.pushFile(fileContent);
    }

    @Override
    public void cleanup() throws IOException {
        this.fileStorage.cleanup();
        super.cleanup();
    }
}

