/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.files.hashcode_cache;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.nio.file.attribute.FileTime;
import java.util.Objects;

public class TimeStampHashCodePair {
    private final FileTime timestamp;
    private final HashCode hashCode;

    public TimeStampHashCodePair(FileTime timestamp, HashCode hashCode) {
        this.hashCode = Preconditions.checkNotNull(hashCode);
        this.timestamp = Preconditions.checkNotNull(timestamp);
    }

    public FileTime getTimestamp() {
        return this.timestamp;
    }

    public HashCode getHashCode() {
        return this.hashCode;
    }

    public int hashCode() {
        return Objects.hash(this.hashCode, this.timestamp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeStampHashCodePair)) {
            return false;
        }
        TimeStampHashCodePair other = (TimeStampHashCodePair)obj;
        return this.getHashCode().equals(other.getHashCode()) && this.getTimestamp().equals(other.getTimestamp());
    }
}

