/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.files.in_memory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.global.file_storage.FileUnknownException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.util.FileUtils;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;

public class InMemoryClientFileStorage
implements ClientFileStorage {
    private final Map<HashCode, FileContent> fileCache = Maps.newHashMap();

    @Override
    public void initialize() throws PermanentStorageException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashCode pushFile(Path file) throws FileNotFoundException, IOException {
        Preconditions.checkNotNull(file);
        FileContent fileContent = FileUtils.getFileContent(file);
        HashCode fileHash = fileContent.getFileHash();
        InMemoryClientFileStorage inMemoryClientFileStorage = this;
        synchronized (inMemoryClientFileStorage) {
            if (!this.fileCache.containsKey(fileHash)) {
                this.fileCache.put(fileHash, fileContent);
            }
        }
        return fileHash;
    }

    @Override
    public boolean isFileKnown(HashCode fileHash) {
        return this.fileCache.containsKey(fileHash);
    }

    @Override
    public FileContent getFile(HashCode fileHash) throws FileUnknownException {
        Preconditions.checkNotNull(fileHash);
        if (!this.fileCache.containsKey(fileHash)) {
            throw new FileUnknownException("File with hash " + fileHash.toString() + " not stored.");
        }
        return this.fileCache.get(fileHash);
    }

    @Override
    public synchronized FileContent getAndRemoveFile(HashCode fileHash) throws FileUnknownException {
        Preconditions.checkNotNull(fileHash);
        if (!this.fileCache.containsKey(fileHash)) {
            throw new FileUnknownException("File with hash " + fileHash.toString() + " not stored.");
        }
        return this.fileCache.remove(fileHash);
    }

    @Override
    public synchronized void removeFile(HashCode fileHash) {
        if (this.fileCache.containsKey(fileHash)) {
            this.fileCache.remove(fileHash);
        }
    }
}

