/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.files.in_place;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.verifiercloud.client.files.BackEndClientFileStorage;
import org.sosy_lab.verifiercloud.global.file_storage.FileUnknownException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.util.FileUtils;
import org.sosy_lab.verifiercloud.global.util.HashUtils;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;

public class InPlaceClientFileStorage
implements BackEndClientFileStorage {
    private final Map<HashCode, Path> files = Collections.synchronizedMap(new HashMap());

    @Override
    public void initialize() throws PermanentStorageException {
    }

    @Override
    public HashCode pushFile(Path file) throws FileNotFoundException, IOException {
        HashCode fileHash = HashUtils.hashFile(file);
        this.files.put(fileHash, file);
        return fileHash;
    }

    @Override
    public void pushFile(Path file, HashCode fileHash) throws IOException {
        this.files.put(fileHash, file);
    }

    @Override
    public FileContent pushFileAndGetFileContent(Path file) throws IOException {
        FileContent fileContent = FileUtils.getFileContent(file);
        this.files.put(fileContent.getFileHash(), file);
        return fileContent;
    }

    @Override
    public boolean isFileKnown(HashCode fileHash) {
        return this.files.containsKey(fileHash);
    }

    @Override
    public FileContent getFile(HashCode fileHash) throws FileUnknownException {
        Preconditions.checkNotNull(fileHash);
        Map<HashCode, Path> map = this.files;
        synchronized (map) {
            if (!this.files.containsKey(fileHash)) {
                throw new FileUnknownException("File with hash " + fileHash + " is unknown.");
            }
            Path filePath = this.files.get(fileHash);
            try {
                FileContent file = FileUtils.getFileContent(filePath);
                if (file.getFileHash().equals(fileHash)) {
                    return file;
                }
                throw new FileUnknownException("File " + filePath + " has changed.");
            }
            catch (IOException e) {
                throw new FileUnknownException(e.getMessage());
            }
        }
    }

    @Override
    public FileContent getAndRemoveFile(HashCode fileHash) throws FileUnknownException {
        Preconditions.checkNotNull(fileHash);
        Map<HashCode, Path> map = this.files;
        synchronized (map) {
            if (!this.files.containsKey(fileHash)) {
                throw new FileUnknownException("File with hash " + fileHash + " is unknown.");
            }
            Path filePath = this.files.remove(fileHash);
            try {
                FileContent file = FileUtils.getFileContent(filePath);
                if (file.getFileHash().equals(fileHash)) {
                    return file;
                }
                throw new FileUnknownException("File " + filePath + " has changed.");
            }
            catch (IOException e) {
                throw new FileUnknownException(e.getMessage());
            }
        }
    }

    @Override
    public void removeFile(HashCode fileHash) {
        this.files.remove(Preconditions.checkNotNull(fileHash));
    }

    @Override
    public boolean isEmpty() {
        return this.files.isEmpty();
    }
}

