/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.files.in_tmp_dir;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import com.google.common.hash.HashCode;
import com.google.inject.name.Named;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.inject.Inject;
import org.sosy_lab.verifiercloud.client.files.BackEndWebClientFileStorage;
import org.sosy_lab.verifiercloud.global.file_storage.FileUnknownException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.util.FileUtils;
import org.sosy_lab.verifiercloud.global.util.HashUtils;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;

public class TmpDirClientFileStorage
implements BackEndWebClientFileStorage {
    public static final String FILE_STORAGE_FOLDER_NAME = "files";
    private Optional<Path> fileDirectory = Optional.absent();
    private final Map<HashCode, Path> visibleFiles = Collections.synchronizedMap(new HashMap());
    private final Path baseWorkingDir;
    private final ReferenceQueue<FileContent> filesToDelete = new ReferenceQueue();
    private final Map<PhantomReference<FileContent>, HashCode> filesWaitingForDeleting = Collections.synchronizedMap(new HashMap());
    private final Map<HashCode, Path> invisibleFiles = Collections.synchronizedMap(new HashMap());
    private final Map<HashCode, FileContent> createdFileContents = new MapMaker().weakValues().makeMap();
    private final FileDeleter fileDeleter;
    private final Logger logger;

    @Inject
    public TmpDirClientFileStorage(@Named(value="local-path") Path baseWorkingDir, Logger logger) {
        this.baseWorkingDir = Preconditions.checkNotNull(baseWorkingDir);
        this.logger = Preconditions.checkNotNull(logger);
        this.fileDeleter = new FileDeleter();
    }

    @Override
    public void initialize() throws PermanentStorageException, IOException {
        Preconditions.checkState(!this.fileDirectory.isPresent(), "%s must not be initialized more than once.", this.getClass().getSimpleName());
        Preconditions.checkNotNull(this.baseWorkingDir);
        Files.createDirectories(this.baseWorkingDir, new FileAttribute[0]);
        Preconditions.checkArgument(Files.isDirectory(this.baseWorkingDir, new LinkOption[0]), "%s is not a directory.", this.baseWorkingDir);
        Path dir = this.baseWorkingDir.resolve(FILE_STORAGE_FOLDER_NAME).resolve(UUID.randomUUID().toString());
        this.fileDirectory = Optional.of(dir);
        Files.createDirectories(this.fileDirectory.get(), new FileAttribute[0]);
        FileUtils.deleteDirectory(this.fileDirectory.get(), this.logger);
        Files.createDirectories(this.fileDirectory.get(), new FileAttribute[0]);
        this.fileDeleter.start();
        this.logger.logf(Level.INFO, "Initialized file storage at %s.", this.fileDirectory.get());
    }

    @Override
    public void cleanup() throws IOException {
        Preconditions.checkState(this.fileDirectory.isPresent(), "%s must be initialized.", this.getClass().getSimpleName());
        this.fileDeleter.stop();
        FileUtils.deleteDirectory(this.fileDirectory.get(), this.logger);
        this.fileDirectory = Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushFile(FileContent fileContent) throws IOException {
        HashCode fileHash = fileContent.getFileHash();
        Path target = this.fileDirectory.get().resolve(fileHash.toString());
        Map<HashCode, Path> map = this.visibleFiles;
        synchronized (map) {
            Path previousPath = this.invisibleFiles.get(fileHash);
            if (previousPath != null) {
                this.visibleFiles.put(fileHash, previousPath);
            } else if (!this.visibleFiles.containsKey(fileHash)) {
                this.createdFileContents.put(fileHash, fileContent);
                fileContent.writeToPath(target);
                this.visibleFiles.put(fileHash, target);
            }
        }
    }

    @Override
    public HashCode pushFile(Path file) throws IOException {
        this.checkIsInitialized();
        HashCode fileHash = HashUtils.hashFile(file);
        this.pushFile(file, fileHash);
        return fileHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushFile(Path file, HashCode fileHash) throws IOException {
        this.checkIsInitialized();
        Map<HashCode, Path> map = this.visibleFiles;
        synchronized (map) {
            Path previousPath = this.invisibleFiles.remove(fileHash);
            if (previousPath != null) {
                this.visibleFiles.put(fileHash, previousPath);
            }
            if (!this.visibleFiles.containsKey(fileHash)) {
                Path internalPath = this.fileDirectory.get().resolve(fileHash.toString());
                this.copyFileToFileDirectory(file, fileHash);
                this.visibleFiles.put(fileHash, internalPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileContent pushFileAndGetFileContent(Path file) throws IOException {
        this.checkIsInitialized();
        Map<HashCode, Path> map = this.visibleFiles;
        synchronized (map) {
            HashCode fileHash = HashUtils.hashFile(file);
            this.pushFile(file, fileHash);
            assert (this.visibleFiles.containsKey(fileHash));
            return this.getFileContent(fileHash);
        }
    }

    private Path copyFileToFileDirectory(Path source, HashCode fileHash) throws IOException {
        Path target = this.fileDirectory.get().resolve(fileHash.toString());
        Preconditions.checkState(!Files.exists(target, new LinkOption[0]));
        Files.copy(source, target, new CopyOption[0]);
        assert (Files.exists(target, new LinkOption[0]));
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFile(HashCode fileHash) {
        this.checkIsInitialized();
        Map<HashCode, Path> map = this.visibleFiles;
        synchronized (map) {
            if (this.visibleFiles.containsKey(fileHash)) {
                this.removeFileFromStorage(fileHash);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileContent getAndRemoveFile(HashCode fileHash) throws FileUnknownException {
        this.checkIsInitialized();
        Preconditions.checkNotNull(fileHash);
        Map<HashCode, Path> map = this.visibleFiles;
        synchronized (map) {
            FileContent file;
            if (!this.visibleFiles.containsKey(fileHash)) {
                throw new FileUnknownException("File with hash " + fileHash + " is unknown.");
            }
            try {
                file = this.getFileContent(fileHash);
                this.removeFileFromStorage(fileHash);
            }
            catch (IOException e) {
                throw new FileUnknownException(e.getMessage());
            }
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFileFromStorage(HashCode fileHash) {
        FileContent fileContent = this.createdFileContents.get(fileHash);
        if (fileContent == null) {
            Map<HashCode, Path> map = this.visibleFiles;
            synchronized (map) {
                Path file = this.visibleFiles.remove(fileHash);
                this.removeFileFromFileDirectory(file);
            }
        }
        Map<HashCode, Path> map = this.invisibleFiles;
        synchronized (map) {
            Path file = this.visibleFiles.remove(fileHash);
            this.invisibleFiles.put(fileHash, file);
            PhantomReference<FileContent> reference = new PhantomReference<FileContent>(fileContent, this.filesToDelete);
            this.filesWaitingForDeleting.put(reference, fileHash);
        }
    }

    private void removeFileFromFileDirectory(Path filePath) {
        try {
            Files.delete(filePath);
        }
        catch (IOException e) {
            this.logger.logf(Level.WARNING, "%s: Cannot remove %s from file storage: %s", e.getClass().getSimpleName(), filePath, e.getMessage());
        }
    }

    @Override
    public FileContent getFile(HashCode fileHash) throws FileUnknownException {
        this.checkIsInitialized();
        Preconditions.checkNotNull(fileHash);
        Map<HashCode, Path> map = this.visibleFiles;
        synchronized (map) {
            if (!this.visibleFiles.containsKey(fileHash)) {
                throw new FileUnknownException("File with hash " + fileHash + " is unknown.");
            }
            try {
                return this.getFileContent(fileHash);
            }
            catch (IOException e) {
                throw new FileUnknownException(e.getMessage());
            }
        }
    }

    private FileContent getFileContent(HashCode fileHash) throws IOException {
        FileContent cachedFileContent = this.createdFileContents.get(fileHash);
        if (cachedFileContent != null) {
            return cachedFileContent;
        }
        Path file = this.visibleFiles.get(fileHash);
        assert (Files.exists(file, new LinkOption[0]));
        FileContent newFileContent = FileUtils.getFileContent(file);
        if (!newFileContent.getFileHash().equals(fileHash)) {
            this.removeFile(fileHash);
            throw new IOException("File " + file + " has changed.");
        }
        this.createdFileContents.put(fileHash, newFileContent);
        return newFileContent;
    }

    @Override
    public boolean isFileKnown(HashCode fileHash) {
        return this.visibleFiles.containsKey(fileHash);
    }

    @Override
    public boolean isEmpty() {
        this.checkIsInitialized();
        return this.visibleFiles.isEmpty();
    }

    private void checkIsInitialized() {
        Preconditions.checkState(this.fileDirectory.isPresent(), "%s must be initialized before calling this method.", this.getClass());
    }

    private class FileDeleter
    implements Runnable {
        private volatile boolean stopped = false;
        private final Thread thread = new Thread(this);

        public FileDeleter() {
            this.thread.setName("ClientFileStorage-FileDeleter");
        }

        public void start() {
            this.thread.start();
        }

        public void stop() {
            TmpDirClientFileStorage.this.logger.logf(Level.INFO, "Stopping the file storage's file deleter thread.", new Object[0]);
            this.stopped = true;
            this.thread.interrupt();
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    this.processNextReference();
                }
                catch (InterruptedException interruptedException) {}
            }
            TmpDirClientFileStorage.this.logger.logf(Level.FINE, "Stopped the file storage's file deleter thread.", new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processNextReference() throws InterruptedException {
            Reference reference = TmpDirClientFileStorage.this.filesToDelete.remove();
            HashCode hash = (HashCode)TmpDirClientFileStorage.this.filesWaitingForDeleting.remove(reference);
            Map map = TmpDirClientFileStorage.this.invisibleFiles;
            synchronized (map) {
                Path fileToDelete = (Path)TmpDirClientFileStorage.this.invisibleFiles.remove(hash);
                if (fileToDelete != null) {
                    TmpDirClientFileStorage.this.removeFileFromFileDirectory(fileToDelete);
                }
            }
        }
    }
}

