/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.interactive;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.client.interactive.CommandEnvironment;
import org.sosy_lab.verifiercloud.client.interactive.CommandParseException;
import org.sosy_lab.verifiercloud.client.interactive.DefaultCommandEnvironment;
import org.sosy_lab.verifiercloud.client.interactive.UserCommandShell;
import org.sosy_lab.verifiercloud.client.interactive.commands.ShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.console.UserConsole;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.run_storage.ClientRunStorage;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.logging.MemoryLogger;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;

public class ConsoleUserCommandShell
implements UserCommandShell {
    private final SystemInformationProvider sysInfoProvider;
    private final MemoryLogger logger;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final UserConsole userConsole;
    private final MasterConnection masterConnection;
    private final ApplicationService client;
    private final ClientFileStorage clientFileStorage;
    private final ClientRunStorage runStorage;
    private volatile Thread readingThread;
    private volatile boolean programActive = false;
    private final CommandEnvironment commandEnv;

    @Inject
    public ConsoleUserCommandShell(UserConsole userConsole, ApplicationService client, MasterConnection masterConnection, ClientRunStorage runStorage, ClientFileStorage clientFileStorage, SystemInformationProvider sysInfoProvider, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, MemoryLogger logger) {
        this.logger = Preconditions.checkNotNull(logger);
        this.userConsole = Preconditions.checkNotNull(userConsole);
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.client = Preconditions.checkNotNull(client);
        this.runStorage = Preconditions.checkNotNull(runStorage);
        this.clientFileStorage = Preconditions.checkNotNull(clientFileStorage);
        this.sysInfoProvider = Preconditions.checkNotNull(sysInfoProvider);
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.commandEnv = this.createInitialCommandEnvironment();
    }

    protected CommandEnvironment createInitialCommandEnvironment() {
        return new DefaultCommandEnvironment(this.userConsole, this.client, this.masterConnection, this.runStorage, this.clientFileStorage, this.sysInfoProvider, this.logger);
    }

    @Override
    public void openShell() {
        try {
            this.clientFileStorage.initialize();
        }
        catch (IOException | PermanentStorageException e) {
            this.userConsole.println("Cannot initialize the file storage: " + e.getMessage() + "The client will be stopped.");
            this.client.stop();
        }
        if (!this.masterConnection.isConnected()) {
            this.userConsole.println("Cannot connect to master " + this.masterConnection.getMasterHostName() + ".\n" + "The client will be stopped.");
            this.client.stop();
        } else {
            Preconditions.checkState(this.readingThread == null);
            this.programActive = true;
            Thread readingThread = new Thread((Runnable)new CommandInputReader(), this.getClass().getSimpleName());
            readingThread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
            readingThread.start();
        }
    }

    @Override
    public void terminateShell() {
        if (this.programActive) {
            this.programActive = false;
            try {
                System.in.close();
            }
            catch (IOException e) {
                this.logger.logf(Level.WARNING, e, "IOException when closing stdin: %s", e.getMessage());
            }
        }
    }

    private String getCurrentPrompt() {
        return this.commandEnv.getPromptExtension() + "> ";
    }

    private class CommandInputReader
    implements Runnable {
        private CommandInputReader() {
        }

        @Override
        public void run() {
            ConsoleUserCommandShell.this.userConsole.println(ConsoleUserCommandShell.this.masterConnection.isConnected() ? "Connection to Master established." : "Warning: Connection to Master not established (Offline mode).");
            while (ConsoleUserCommandShell.this.programActive) {
                String rawInput = ConsoleUserCommandShell.this.userConsole.readLine(ConsoleUserCommandShell.this.getCurrentPrompt());
                if (rawInput == null) {
                    ConsoleUserCommandShell.this.client.stop();
                    return;
                }
                Iterable<String> commandTokens = Splitter.on(Pattern.compile("[ \t]")).omitEmptyStrings().split(rawInput);
                this.executeCommand(rawInput, commandTokens);
            }
        }

        private void executeCommand(String rawInput, Iterable<String> commandTokens) {
            Iterator<String> tokenIt = commandTokens.iterator();
            if (!tokenIt.hasNext()) {
                return;
            }
            ShellCommand cmd = ConsoleUserCommandShell.this.commandEnv.getApplicableCommand(tokenIt);
            if (FluentIterable.from(commandTokens).size() <= cmd.argumentDescription().size()) {
                ConsoleUserCommandShell.this.userConsole.println("Missing arguments! Please provide at least the following:");
                for (Map.Entry currentArgument : cmd.argumentDescription().entrySet()) {
                    ConsoleUserCommandShell.this.userConsole.println(String.format("\t%s\t%s", currentArgument.getKey(), currentArgument.getValue()));
                }
            } else {
                try {
                    cmd.process(rawInput, tokenIt);
                }
                catch (CommandParseException e) {
                    ConsoleUserCommandShell.this.userConsole.println("Wrong command usage: " + e.getMessage());
                }
            }
        }
    }
}

