/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.interactive;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.client.interactive.CommandEnvironment;
import org.sosy_lab.verifiercloud.client.interactive.CommandParseException;
import org.sosy_lab.verifiercloud.client.interactive.commands.AbstractShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.commands.AuthenticationShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.commands.ChangePriorityShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.commands.ExitShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.commands.MasterInfoCommand;
import org.sosy_lab.verifiercloud.client.interactive.commands.PrintLogsShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.commands.ResultsShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.commands.RunCollectionCreationShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.commands.ShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.commands.StopMasterShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.commands.StopRunCollectionCommand;
import org.sosy_lab.verifiercloud.client.interactive.commands.WorkerControlShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.console.UserConsole;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.run_storage.ClientRunStorage;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.logging.MemoryLogger;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;

public class DefaultCommandEnvironment
implements CommandEnvironment {
    private final UserConsole userConsole;
    private final MasterConnection masterConnection;
    private final List<ShellCommand> availableCommands = Lists.newArrayList();

    public DefaultCommandEnvironment(UserConsole userConsole, ApplicationService client, MasterConnection masterConnection, ClientRunStorage runStorage, ClientFileStorage clientFileStorage, SystemInformationProvider sysInfoProvider, MemoryLogger logger) {
        this.userConsole = Preconditions.checkNotNull(userConsole);
        this.masterConnection = masterConnection;
        this.registerAvailableCommand(new AuthenticationShellCommand(masterConnection, userConsole, sysInfoProvider));
        this.registerAvailableCommand(new PrintLogsShellCommand(logger, userConsole));
        this.registerAvailableCommand(new MasterInfoCommand(masterConnection, userConsole));
        ResultsShellCommand resultCommand = new ResultsShellCommand(masterConnection, runStorage, userConsole);
        this.registerAvailableCommand(resultCommand);
        this.registerAvailableCommand(new StopMasterShellCommand(masterConnection, userConsole));
        this.registerAvailableCommand(new WorkerControlShellCommand(masterConnection, userConsole));
        this.registerAvailableCommand(new ChangePriorityShellCommand(masterConnection, userConsole));
        this.registerAvailableCommand(new RunCollectionCreationShellCommand(masterConnection, resultCommand, clientFileStorage, userConsole));
        this.registerAvailableCommand(new StopRunCollectionCommand(masterConnection, userConsole));
        this.registerAvailableCommand(new PrintHelpCommand());
        this.registerAvailableCommand(new ExitShellCommand(client, userConsole));
        this.registerAvailableCommand(new DefaultShellCommand());
    }

    @Override
    public String getPromptExtension() {
        return String.format("%s@%s", new Object[]{this.masterConnection.getAuthorization(), this.masterConnection.getMasterHostName()});
    }

    @Override
    public void registerAvailableCommand(ShellCommand command) {
        this.availableCommands.add(command);
    }

    @Override
    public ShellCommand getApplicableCommand(Iterator<String> commandTokens) {
        Preconditions.checkArgument(commandTokens.hasNext(), "No command given.");
        String command = commandTokens.next();
        for (ShellCommand shellCommand : this.availableCommands) {
            if (!shellCommand.isApplicable(command)) continue;
            return shellCommand;
        }
        throw new RuntimeException("No command found.");
    }

    @Override
    public List<ShellCommand> getAvailableCommands() {
        return this.availableCommands;
    }

    private class DefaultShellCommand
    extends AbstractShellCommand {
        private DefaultShellCommand() {
        }

        @Override
        public boolean isApplicable(String command) {
            return true;
        }

        @Override
        public void process(String rawCommand, Iterator<String> tokens) throws CommandParseException {
            DefaultCommandEnvironment.this.userConsole.println("Unknown command: " + rawCommand);
        }

        @Override
        public String getHelpText() {
            return "";
        }

        @Override
        public String getCommandName() {
            return "";
        }
    }

    private class PrintHelpCommand
    extends AbstractShellCommand {
        private PrintHelpCommand() {
        }

        @Override
        public String getCommandName() {
            return "help";
        }

        @Override
        public void process(String rawCommand, Iterator<String> tokens) throws CommandParseException {
            DefaultCommandEnvironment.this.userConsole.println("Available commands:\n");
            for (ShellCommand shellCommand : DefaultCommandEnvironment.this.getAvailableCommands()) {
                DefaultCommandEnvironment.this.userConsole.println(shellCommand.getHelpText());
            }
        }
    }
}

