/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.interactive.commands;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.Iterator;
import org.sosy_lab.verifiercloud.client.interactive.CommandParseException;
import org.sosy_lab.verifiercloud.client.interactive.commands.AbstractShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.console.UserConsole;
import org.sosy_lab.verifiercloud.client.network.ClientAuthorizationState;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.exceptions.AuthenticationFailedException;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.master.clientside.ClientAccessLevel;

public class AuthenticationShellCommand
extends AbstractShellCommand {
    private final UserConsole console;
    private final MasterConnection masterConnection;
    private final SystemInformationProvider sysInfoProvider;

    public AuthenticationShellCommand(MasterConnection masterConnection, UserConsole console, SystemInformationProvider sysInfoProvider) {
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.console = Preconditions.checkNotNull(console);
        this.sysInfoProvider = Preconditions.checkNotNull(sysInfoProvider);
    }

    @Override
    public String getCommandName() {
        return "auth";
    }

    @Override
    public ImmutableMap<String, String> argumentDescription() {
        return new ImmutableMap.Builder<String, String>().put("level", "Desired access level, may be 'user' or 'admin'.").build();
    }

    @Override
    public void process(String rawCommand, Iterator<String> remainingTokens) throws CommandParseException {
        ClientAuthorizationState newState;
        ClientAccessLevel level;
        if (!this.masterConnection.isConnected()) {
            throw new CommandParseException("Command requires connection to Master.");
        }
        String desiredLevelInput = remainingTokens.next();
        if (desiredLevelInput.equalsIgnoreCase("user")) {
            level = ClientAccessLevel.USER;
        } else if (desiredLevelInput.equalsIgnoreCase("admin")) {
            level = ClientAccessLevel.ADMIN;
        } else {
            this.console.println("Authenticating failed: invalid access level " + desiredLevelInput);
            return;
        }
        String username = this.sysInfoProvider.getUsername();
        CheckedFuture<ClientAuthorizationState, AuthenticationFailedException> futureState = this.masterConnection.authenticate(level, username);
        try {
            newState = futureState.checkedGet();
        }
        catch (AuthenticationFailedException e) {
            this.console.println("Authenticating failed: " + e.getMessage());
            return;
        }
        this.console.println("Now authorized as " + (Object)((Object)newState));
    }

    @Override
    public String getHelpText() {
        return this.getCommandName() + "\t" + "username";
    }
}

