/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.interactive.commands;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.Iterator;
import org.sosy_lab.verifiercloud.client.interactive.CommandParseException;
import org.sosy_lab.verifiercloud.client.interactive.commands.AbstractShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.console.UserConsole;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.Success;
import org.sosy_lab.verifiercloud.client.network.exceptions.RequestFailureException;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;

public class ChangePriorityShellCommand
extends AbstractShellCommand {
    private MasterConnection masterConnection;
    private final UserConsole console;

    public ChangePriorityShellCommand(MasterConnection masterConnection, UserConsole console) {
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.console = Preconditions.checkNotNull(console);
    }

    @Override
    public String getCommandName() {
        return "renice";
    }

    @Override
    public void process(String rawCommand, Iterator<String> remainingTokens) throws CommandParseException {
        SchedulingPriority priority;
        if (!remainingTokens.hasNext()) {
            throw new CommandParseException("Missing runCollectionId.");
        }
        String runCollectionId = remainingTokens.next();
        if (!remainingTokens.hasNext()) {
            throw new CommandParseException("Missing priority.");
        }
        try {
            priority = SchedulingPriority.valueOf(remainingTokens.next());
        }
        catch (IllegalArgumentException e) {
            this.console.println("Illegal priority.");
            return;
        }
        CheckedFuture<Success, RequestFailureException> changeRunCollectionPriority = this.masterConnection.changeRunCollectionPriority(runCollectionId, priority);
        try {
            changeRunCollectionPriority.checkedGet();
            this.console.println("Successfully changed priority.");
        }
        catch (RequestFailureException e) {
            this.console.println(e.getMessage());
        }
    }

    @Override
    public String getHelpText() {
        return this.getCommandName() + "\t" + " runCollectionId " + "( " + Joiner.on(", ").join((Object[])SchedulingPriority.values()) + " )";
    }
}

