/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.interactive.commands;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.Iterator;
import org.sosy_lab.verifiercloud.client.interactive.CommandParseException;
import org.sosy_lab.verifiercloud.client.interactive.commands.AbstractShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.console.UserConsole;
import org.sosy_lab.verifiercloud.client.network.ClientAuthorizationState;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.exceptions.MasterSummaryNotRetrievableException;
import org.sosy_lab.verifiercloud.transportable.info.master.MasterSummary;
import org.sosy_lab.verifiercloud.transportable.info.master.WorkerSummary;

public class MasterInfoCommand
extends AbstractShellCommand {
    private final MasterConnection masterConnection;
    private final UserConsole console;

    public MasterInfoCommand(MasterConnection masterConnection, UserConsole console) {
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.console = Preconditions.checkNotNull(console);
    }

    @Override
    public String getCommandName() {
        return "info";
    }

    @Override
    public void process(String rawCommand, Iterator<String> command) throws CommandParseException {
        Optional<MasterSummary> optionalMasterSummary;
        ClientAuthorizationState state = this.masterConnection.getAuthorization();
        if (!command.hasNext()) {
            this.printConnectionState(state);
        }
        if (!(optionalMasterSummary = this.getMasterSummary()).isPresent()) {
            return;
        }
        MasterSummary masterSummary = optionalMasterSummary.get();
        if (!command.hasNext()) {
            this.console.println(masterSummary.getDetailedDescription());
            return;
        }
        String subCommand = command.next();
        if (subCommand.equals("workers")) {
            this.console.println("Current workers:");
            this.console.println(masterSummary.getTabularWorkerView());
        } else if (subCommand.equals("worker") && command.hasNext()) {
            String workerName = command.next();
            for (WorkerSummary worker : masterSummary.getWorkerSummaries()) {
                if (!worker.getWorkerHostname().equalsIgnoreCase(workerName)) continue;
                this.console.println(worker.getFullDescription());
                return;
            }
            this.console.println("Worker '" + workerName + "' unknown.");
        } else if (subCommand.equals("runs")) {
            this.console.println(masterSummary.getTabularRunCollectionsView());
        } else {
            throw new CommandParseException("Wrong usage of info command.");
        }
    }

    private Optional<MasterSummary> getMasterSummary() {
        CheckedFuture<MasterSummary, MasterSummaryNotRetrievableException> futureMasterSummary = this.masterConnection.getMasterSummary();
        try {
            MasterSummary masterSummary = futureMasterSummary.checkedGet();
            return Optional.of(masterSummary);
        }
        catch (MasterSummaryNotRetrievableException e) {
            this.console.println("Cannot print summary: " + e.getMessage());
            return Optional.absent();
        }
    }

    private void printConnectionState(ClientAuthorizationState state) {
        this.console.println("Connection state: " + state.toString().toLowerCase());
    }

    @Override
    public String getHelpText() {
        return this.getCommandName() + "\t" + "[ workers | worker <hostname> | runs ]";
    }
}

