/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.interactive.commands;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.client.interactive.CommandParseException;
import org.sosy_lab.verifiercloud.client.interactive.commands.AbstractShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.console.UserConsole;
import org.sosy_lab.verifiercloud.global.logging.MemoryLogger;

public class PrintLogsShellCommand
extends AbstractShellCommand {
    private final MemoryLogger logger;
    private final UserConsole console;

    public PrintLogsShellCommand(MemoryLogger logger, UserConsole console) {
        this.logger = Preconditions.checkNotNull(logger);
        this.console = Preconditions.checkNotNull(console);
    }

    @Override
    public String getCommandName() {
        return "logs";
    }

    @Override
    public void process(String rawCommand, Iterator<String> remainingTokens) throws CommandParseException {
        Level requestLevel = Level.ALL;
        if (remainingTokens.hasNext()) {
            String parameter = remainingTokens.next();
            try {
                requestLevel = Level.parse(parameter.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new CommandParseException(parameter + " not allowed.");
            }
        }
        List<String> logMessages = this.logger.getLogs(requestLevel);
        for (String message : logMessages) {
            this.console.println(message);
        }
    }

    @Override
    public String getHelpText() {
        Object[] levels = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE};
        return this.getCommandName() + "\t[ " + Joiner.on(" | ").join(levels) + " ]";
    }
}

