/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.interactive.commands;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.sosy_lab.verifiercloud.client.interactive.CommandParseException;
import org.sosy_lab.verifiercloud.client.interactive.commands.AbstractShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.commands.RunCollectionCreationShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.console.UserConsole;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.exceptions.FileNotAvailableOnTheMaster;
import org.sosy_lab.verifiercloud.client.network.exceptions.RunCanceledException;
import org.sosy_lab.verifiercloud.client.run_storage.ClientRunStorage;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;

public class ResultsShellCommand
extends AbstractShellCommand {
    private static final Joiner COMMAND_JOINER = Joiner.on(" ");
    private final MasterConnection masterConnection;
    private final ClientRunStorage runStorage;
    private final UserConsole console;
    SetMultimap<RunCollection, Future<RunResult>> runCollectionToRunResults = HashMultimap.create();

    public ResultsShellCommand(MasterConnection masterConnection, ClientRunStorage runStorage, UserConsole console) {
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.runStorage = Preconditions.checkNotNull(runStorage);
        this.console = Preconditions.checkNotNull(console);
    }

    @Override
    public String getCommandName() {
        return "results";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String rawCommand, Iterator<String> remainingTokens) throws CommandParseException {
        boolean verbose = false;
        if (remainingTokens.hasNext() && remainingTokens.next().equals("verbose")) {
            verbose = true;
        }
        ClientRunStorage clientRunStorage = this.runStorage;
        synchronized (clientRunStorage) {
            Set<RunCollection> allRunCollections = this.runCollectionToRunResults.keySet();
            Collection<RunCollection> finishedRunCollections = this.getFinishedRunCollections(allRunCollections);
            this.console.println("Run Collections: " + allRunCollections.size() + " (finished: " + finishedRunCollections.size() + ")");
            for (RunCollection runCollection : allRunCollections) {
                String runCollectionName = " " + runCollection + ": ";
                if (verbose) {
                    this.getAndPrintResults(runCollection);
                    continue;
                }
                if (finishedRunCollections.contains(runCollection)) {
                    this.console.println(runCollectionName + "FINISHED");
                    continue;
                }
                int numberOfFinishedRuns = this.getNumberOfFinishedRuns(runCollection);
                int overallNumberOfRuns = runCollection.getRuns().size();
                this.console.println(runCollectionName + " (" + numberOfFinishedRuns + " of " + overallNumberOfRuns + ")");
            }
        }
    }

    private void getAndPrintResults(RunCollection runCollection) {
        for (Future<RunResult> runResultFuture : this.runCollectionToRunResults.get(runCollection)) {
            if (!runResultFuture.isDone()) continue;
            try {
                RunResult runResult = runResultFuture.get();
                Optional<Object> outputContent = Optional.absent();
                for (FileAtRelativePath resultFile : runResult.getResultFiles()) {
                    if (!resultFile.getRelativePath().equals(RunCollectionCreationShellCommand.OUTPUT_FILE_NAME)) continue;
                    CheckedFuture<FileContent, FileNotAvailableOnTheMaster> outputFuture = this.masterConnection.getResultFile(resultFile.getFileHash());
                    outputContent = Optional.of(outputFuture.get());
                }
                String command = COMMAND_JOINER.join(runResult.getRun().getCommand());
                this.console.println("Run: " + command);
                if (outputContent.isPresent()) {
                    this.console.println(((FileContent)outputContent.get()).getContent());
                } else {
                    this.console.println("No ouput.");
                }
                this.console.println("");
            }
            catch (InterruptedException | ExecutionException e) {
                this.console.println("Can not get run result");
            }
        }
    }

    private int getNumberOfFinishedRuns(RunCollection runCollection) {
        int numberOfFinishedRuns = 0;
        for (Future<RunResult> runResultFuture : this.runCollectionToRunResults.get(runCollection)) {
            if (!runResultFuture.isDone()) continue;
            ++numberOfFinishedRuns;
        }
        return numberOfFinishedRuns;
    }

    private Collection<RunCollection> getFinishedRunCollections(Collection<RunCollection> allRunCollections) {
        ArrayList<RunCollection> finishedRunCollections = Lists.newArrayList();
        for (RunCollection runCollection : allRunCollections) {
            boolean finished = true;
            for (Future<RunResult> runResultFuture : this.runCollectionToRunResults.get(runCollection)) {
                if (runResultFuture.isDone()) continue;
                finished = false;
            }
            if (!finished) continue;
            finishedRunCollections.add(runCollection);
        }
        return finishedRunCollections;
    }

    @Override
    public String getHelpText() {
        return this.getCommandName() + "\t" + "[verbose]";
    }

    public void addResultFutres(RunCollection runCollection, List<CheckedFuture<RunResult, RunCanceledException>> resultFutures) {
        Preconditions.checkState(!this.runCollectionToRunResults.containsKey(runCollection));
        for (Future future : resultFutures) {
            this.runCollectionToRunResults.put(runCollection, future);
        }
    }
}

