/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.interactive.commands;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.client.interactive.CommandParseException;
import org.sosy_lab.verifiercloud.client.interactive.commands.AbstractShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.commands.ResultsShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.console.UserConsole;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.exceptions.InsufficientRightsException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RunCanceledException;
import org.sosy_lab.verifiercloud.client.run_builders.MultiFileRunCollectionBuilder;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionBuilder;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionCreationException;
import org.sosy_lab.verifiercloud.client.run_builders.TrivialTestRunCollectionBuilder;
import org.sosy_lab.verifiercloud.global.logging.LoggerBuilder;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.RelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.StringRelativePath;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.LimitationsBuilder;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.RequirementsBuilder;
import org.sosy_lab.verifiercloud.transportable.run.filters.AllFileFilter;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class RunCollectionCreationShellCommand
extends AbstractShellCommand {
    protected static final RelativePath OUTPUT_FILE_NAME = StringRelativePath.from("output.txt");
    private final MasterConnection masterConnection;
    private final ClientFileStorage clientFileStorage;
    private final UserConsole console;
    private final ResultsShellCommand resultCommand;

    public RunCollectionCreationShellCommand(MasterConnection masterConnection, ResultsShellCommand resultCommand, ClientFileStorage clientFileStorage, UserConsole console) {
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.resultCommand = Preconditions.checkNotNull(resultCommand);
        this.clientFileStorage = Preconditions.checkNotNull(clientFileStorage);
        this.console = Preconditions.checkNotNull(console);
    }

    @Override
    public String getCommandName() {
        return "run";
    }

    @Override
    public ImmutableMap<String, String> argumentDescription() {
        return new ImmutableMap.Builder<String, String>().put("type", "Type of run collection to be created and started.").build();
    }

    @Override
    public void process(String rawCommand, Iterator<String> remainingTokens) throws CommandParseException {
        RunCollectionBuilder<RunCollectionCreationException> runCollectionBuilder;
        String testSet = remainingTokens.next();
        if (testSet.equals("trivial")) {
            runCollectionBuilder = new TrivialTestRunCollectionBuilder(OUTPUT_FILE_NAME);
        } else if (testSet.equals("cpachecker")) {
            try {
                runCollectionBuilder = this.cpachecker();
            }
            catch (RunCollectionCreationException e) {
                this.console.println(e.getLocalizedMessage());
                return;
            }
        } else if (testSet.equals("wc")) {
            if (!remainingTokens.hasNext()) {
                throw new CommandParseException("Option 'wc' expects a parameter.");
            }
            try {
                runCollectionBuilder = this.wc(remainingTokens.next());
            }
            catch (RunCollectionCreationException e) {
                this.console.println(e.getLocalizedMessage());
                return;
            }
        } else {
            throw new CommandParseException("Option '" + testSet + "' unknown.");
        }
        this.createAndSendRunCollection(runCollectionBuilder);
    }

    private void createAndSendRunCollection(RunCollectionBuilder<RunCollectionCreationException> runCollectionBuilder) {
        RunCollection runCollection;
        try {
            runCollection = runCollectionBuilder.createRunCollection();
        }
        catch (RunCollectionCreationException e) {
            this.console.println("Cannot create Task because: " + e.getMessage());
            return;
        }
        try {
            List<CheckedFuture<RunResult, RunCanceledException>> resultFutures = this.masterConnection.sendRunCollection(runCollection, false);
            this.resultCommand.addResultFutres(runCollection, resultFutures);
            this.waitForResults(resultFutures);
        }
        catch (InsufficientRightsException e) {
            this.console.println("Error: " + e.getMessage());
        }
    }

    private void waitForResults(List<CheckedFuture<RunResult, RunCanceledException>> resultFutures) {
        final int numberOfRuns = resultFutures.size();
        final CountDownLatch runResults = new CountDownLatch(numberOfRuns);
        final AtomicInteger receivedRunResults = new AtomicInteger(0);
        for (CheckedFuture<RunResult, RunCanceledException> checkedFuture : resultFutures) {
            Futures.addCallback(checkedFuture, new FutureCallback<RunResult>(){

                @Override
                public void onSuccess(RunResult result) {
                    int number = receivedRunResults.incrementAndGet();
                    RunCollectionCreationShellCommand.this.console.println("Received " + number + " of " + numberOfRuns + " run results.");
                    runResults.countDown();
                }

                @Override
                public void onFailure(Throwable t) {
                    int number = receivedRunResults.incrementAndGet();
                    RunCollectionCreationShellCommand.this.console.println(number + " run failed.");
                    runResults.countDown();
                }
            });
        }
        try {
            runResults.await();
            this.console.println("Received all results.");
        }
        catch (InterruptedException e) {
            this.console.println("Interrupt while waiting for results.");
        }
    }

    private RunCollectionBuilder<RunCollectionCreationException> wc(String filename) throws RunCollectionCreationException {
        MultiFileRunCollectionBuilder multiFileRunCollectionBuilder = new MultiFileRunCollectionBuilder(ImmutableList.of("wc"), this.clientFileStorage, LimitationsBuilder.from(TimeInterval.minutes(15L)).build(), RequirementsBuilder.withProcessors(1).build(), Paths.get(".", new String[0]), OUTPUT_FILE_NAME, new AllFileFilter(), LoggerBuilder.create().build());
        Path file = Paths.get(filename, new String[0]);
        Path parentDir = file.toAbsolutePath().normalize().getParent();
        try {
            multiFileRunCollectionBuilder.addInputFiles(file, parentDir);
        }
        catch (IllegalArgumentException e) {
            throw new RunCollectionCreationException("Error: " + e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            throw new RunCollectionCreationException("Error: " + file.toString() + " does not exist.");
        }
        catch (IOException e) {
            throw new RunCollectionCreationException("IOError when accessing " + file.toString() + ": " + e.getMessage());
        }
        return multiFileRunCollectionBuilder;
    }

    private RunCollectionBuilder<RunCollectionCreationException> cpachecker() throws RunCollectionCreationException {
        MultiFileRunCollectionBuilder multiFileRunCollectionBuilder = new MultiFileRunCollectionBuilder(ImmutableList.of("scripts/cpa.sh", "-explicitAnalysis", "-heap", "12000M"), this.clientFileStorage, LimitationsBuilder.from(TimeInterval.minutes(15L)).build(), RequirementsBuilder.withProcessors(1).build(), Paths.get(".", new String[0]), OUTPUT_FILE_NAME, new AllFileFilter(), LoggerBuilder.create().build());
        Path programRootDirectory = Paths.get("./test-input/CPAchecker", new String[0]);
        Path inputRootDir = Paths.get("./test-input", new String[0]);
        Path inputDir = Paths.get("./test-input/programs", new String[0]);
        try {
            multiFileRunCollectionBuilder.addProgramFiles(programRootDirectory, programRootDirectory);
            multiFileRunCollectionBuilder.addInputFiles(inputDir, inputRootDir);
        }
        catch (FileNotFoundException e) {
            throw new RunCollectionCreationException("File not found when building run collection: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RunCollectionCreationException("IO problem when building run collection: " + e.getMessage());
        }
        return multiFileRunCollectionBuilder;
    }

    @Override
    public String getHelpText() {
        return this.getCommandName() + "\t" + "(trivial | wc <file> | cpachecker)";
    }
}

