/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.interactive.commands;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.Iterator;
import org.sosy_lab.verifiercloud.client.interactive.CommandParseException;
import org.sosy_lab.verifiercloud.client.interactive.commands.AbstractShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.console.UserConsole;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.Success;
import org.sosy_lab.verifiercloud.client.network.exceptions.RequestFailureException;

public class StopMasterShellCommand
extends AbstractShellCommand {
    private final MasterConnection masterConnection;
    private final UserConsole console;

    public StopMasterShellCommand(MasterConnection masterConnection, UserConsole console) {
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.console = Preconditions.checkNotNull(console);
    }

    @Override
    public String getCommandName() {
        return "shutdown";
    }

    @Override
    public void process(String rawCommand, Iterator<String> tokens) throws CommandParseException {
        try {
            CheckedFuture<Success, RequestFailureException> stopMaster = this.masterConnection.stopMaster();
            stopMaster.checkedGet();
            this.console.println("Master is shutting down.");
        }
        catch (RequestFailureException e) {
            this.console.println(e.getMessage());
        }
    }

    @Override
    public String getHelpText() {
        return this.getCommandName();
    }
}

