/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.interactive.commands;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.Iterator;
import org.sosy_lab.verifiercloud.client.interactive.CommandParseException;
import org.sosy_lab.verifiercloud.client.interactive.commands.AbstractShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.console.UserConsole;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.Success;
import org.sosy_lab.verifiercloud.client.network.exceptions.RequestFailureException;

public class StopRunCollectionCommand
extends AbstractShellCommand {
    private final MasterConnection masterConnection;
    private final UserConsole console;

    public StopRunCollectionCommand(MasterConnection masterConnection, UserConsole console) {
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.console = Preconditions.checkNotNull(console);
    }

    @Override
    public String getCommandName() {
        return "cancel";
    }

    @Override
    public void process(String rawCommand, Iterator<String> remainingTokens) throws CommandParseException {
        if (!remainingTokens.hasNext()) {
            throw new CommandParseException("Missing parameter: run collection id");
        }
        String id = remainingTokens.next();
        CheckedFuture<Success, RequestFailureException> stopRunCollection = this.masterConnection.stopRunCollection(id);
        try {
            stopRunCollection.checkedGet();
            this.console.println("Successfully stopped run collection.");
        }
        catch (RequestFailureException e) {
            this.console.println("Failed to stop run collection: " + e.getMessage());
        }
    }

    @Override
    public String getHelpText() {
        return this.getCommandName() + "\t" + "<run-collection-ID>";
    }
}

