/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.interactive.commands;

import com.google.common.base.Preconditions;
import java.nio.file.Paths;
import java.util.Iterator;
import org.sosy_lab.verifiercloud.client.interactive.CommandParseException;
import org.sosy_lab.verifiercloud.client.interactive.commands.AbstractShellCommand;
import org.sosy_lab.verifiercloud.client.interactive.console.UserConsole;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.exceptions.RequestFailureException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;
import org.sosy_lab.verifiercloud.global.util.StringBooleanConverter;
import org.sosy_lab.verifiercloud.transportable.workerstart.WorkerStartInformation;

public class WorkerControlShellCommand
extends AbstractShellCommand {
    private final UserConsole console;
    private final MasterConnection masterConnection;

    public WorkerControlShellCommand(MasterConnection masterConnection, UserConsole userConsole) {
        this.masterConnection = masterConnection;
        this.console = Preconditions.checkNotNull(userConsole);
    }

    @Override
    public String getCommandName() {
        return "worker";
    }

    @Override
    public void process(String rawCommand, Iterator<String> remainingTokens) throws CommandParseException {
        if (!remainingTokens.hasNext()) {
            throw new CommandParseException("Missing host name.");
        }
        String subCommand = remainingTokens.next();
        if (!remainingTokens.hasNext()) {
            return;
        }
        if (subCommand.equals("start")) {
            this.start(remainingTokens);
            return;
        }
        if (subCommand.equals("stop")) {
            this.stop(remainingTokens);
            return;
        }
        this.console.println(this.getHelpText());
    }

    private void stop(Iterator<String> tokens) {
        String hostname = tokens.next();
        try {
            this.masterConnection.removeWorker(hostname).checkedGet();
            this.console.println("Removed " + hostname + " from list of workers.");
        }
        catch (RequestFailureException e) {
            this.console.println(e.getMessage());
        }
    }

    private void start(Iterator<String> tokens) {
        String hostname = tokens.next();
        WorkerStartInformation.WorkerStartInformationBuilder builder = WorkerStartInformation.WorkerStartInformationBuilder.forHost(hostname);
        if (tokens.hasNext()) {
            String usercheck = tokens.next();
            try {
                builder.setUserLoginCheck(StringBooleanConverter.stringToBoolean(usercheck));
            }
            catch (InvalidOptionException e) {
                this.console.println(this.getHelpText());
                return;
            }
            if (tokens.hasNext()) {
                String path = tokens.next();
                if (!path.equals("-")) {
                    Paths.get(path, new String[0]);
                    builder.setPath(path);
                }
                if (tokens.hasNext()) {
                    String reverseTunnel = tokens.next();
                    try {
                        builder.setUseReverseTunnel(StringBooleanConverter.stringToBoolean(reverseTunnel));
                    }
                    catch (InvalidOptionException e) {
                        this.console.println(this.getHelpText());
                        return;
                    }
                }
            }
        }
        try {
            this.masterConnection.addWorker(builder.build()).checkedGet();
            this.console.println("Adding " + hostname + " to list of workers.");
        }
        catch (RequestFailureException e) {
            this.console.println(e.getMessage());
        }
    }

    @Override
    public String getHelpText() {
        return this.getCommandName() + "\t" + "(start <hostname> [<usercheck> [- | <path> [<reverse-tunnel]]] | stop <hostname>)";
    }
}

