/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.interactive.console;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.sosy_lab.verifiercloud.client.interactive.console.UserConsole;

public class ConsoleBridge
implements UserConsole {
    private final UserConsole implementation = System.console() == null ? new SystemIoConsole() : new SystemShellConsole();

    @Override
    public String readLine(String prompt) {
        return this.implementation.readLine(prompt);
    }

    @Override
    public void println(String str) {
        this.implementation.println(str);
    }

    private static class SystemIoConsole
    implements UserConsole {
        private InputStreamReader inStream = new InputStreamReader(System.in, Charsets.UTF_8);
        private BufferedReader inReader = new BufferedReader(this.inStream);

        private SystemIoConsole() {
        }

        @Override
        public String readLine(String prompt) {
            System.out.print(prompt);
            try {
                return this.inReader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException("Reading from System.in failed!");
            }
        }

        @Override
        public void println(String str) {
            System.out.println(str);
        }
    }

    private static class SystemShellConsole
    implements UserConsole {
        private Console console = System.console();
        private PrintWriter writer = System.console().writer();

        private SystemShellConsole() {
        }

        @Override
        public String readLine(String prompt) {
            return this.console.readLine(prompt, new Object[0]);
        }

        @Override
        public void println(String str) {
            this.writer.println(str);
        }
    }
}

