/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.network;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.inject.Inject;
import java.util.UUID;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.client.network.ClientAPI;
import org.sosy_lab.verifiercloud.client.network.MasterAbstraction;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.Success;
import org.sosy_lab.verifiercloud.client.network.exceptions.InsufficientRightsException;
import org.sosy_lab.verifiercloud.client.network.results.ActiveRequests;
import org.sosy_lab.verifiercloud.client.run_storage.ClientRunStorage;
import org.sosy_lab.verifiercloud.global.file_storage.FileUnknownException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.master.clientside.ClientAccessLevel;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.master.MasterSummary;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;

public class DefaultClientAPI
implements ClientAPI {
    private final Logger logger;
    private final MasterConnection masterConnection;
    private final ClientRunStorage runStorage;
    private final ClientFileStorage clientFileStorage;
    private final ActiveRequests activeRequest;

    @Inject
    public DefaultClientAPI(MasterConnection masterConnection, ClientRunStorage runStorage, ClientFileStorage clientFileStorage, ActiveRequests activeRequest, Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.runStorage = Preconditions.checkNotNull(runStorage);
        this.clientFileStorage = Preconditions.checkNotNull(clientFileStorage);
        this.activeRequest = Preconditions.checkNotNull(activeRequest);
    }

    @Override
    public void masterShuttingDownInformation(MasterAbstraction masterAbstraction) {
        this.logger.logf(Level.INFO, "Master is shutting down.", new Object[0]);
        masterAbstraction.terminateCommunication();
    }

    @Override
    public void setAuthenticationStatus(ClientAccessLevel level, UUID requestId) {
        this.logger.logf(Level.FINE, "Received authentication status %s", new Object[]{level});
        this.activeRequest.setSuccess(level, requestId);
    }

    @Override
    public void declineFile(HashCode fileHash) {
        this.clientFileStorage.removeFile(fileHash);
    }

    @Override
    public void requestFile(HashCode fileHash) {
        FileContent fileContent;
        Preconditions.checkNotNull(fileHash);
        this.logger.logf(Level.FINER, "Master requested file %s.", fileHash);
        try {
            fileContent = this.clientFileStorage.getAndRemoveFile(fileHash);
        }
        catch (FileUnknownException e) {
            this.logger.logf(Level.SEVERE, e, "Master requested unknown file %s.", fileHash);
            return;
        }
        try {
            this.masterConnection.sendFile(fileContent);
        }
        catch (InsufficientRightsException e) {
            this.logger.logf(Level.WARNING, "Not enough rights to send requested file: %s", e.getMessage());
        }
    }

    @Override
    public void setMasterSummary(MasterSummary masterSummary, UUID requestId) {
        Preconditions.checkState(this.activeRequest.hasRequestPending(requestId), "Client currently has no request pending.");
        this.activeRequest.setSuccess(masterSummary, requestId);
    }

    @Override
    public void setRunResult(Run run, RunResult runResult) {
        Preconditions.checkArgument(runResult.getRun().equals(run));
        this.logger.logf(Level.FINE, "Received result for %s.", run);
        this.runStorage.addRunResult(run, runResult);
    }

    @Override
    public void markRunAsCanceled(Run run, Exception reason) {
        this.logger.logf(Level.INFO, "%s failed: %s", run, reason);
        this.runStorage.markAsCanceled(run, reason);
    }

    @Override
    public void setResultFile(FileContent file, UUID requestId) {
        Preconditions.checkState(this.activeRequest.hasRequestPending(requestId), "Client currently has no request pending.");
        this.activeRequest.setSuccess(file, requestId);
    }

    @Override
    public void setRunResult(String runId, FileContent runResultAsZip, UUID requestId) {
        Preconditions.checkState(this.activeRequest.hasRequestPending(requestId), "Client currently has no request pending.");
        this.activeRequest.setSuccess(runResultAsZip, requestId);
    }

    @Override
    public void requestFailed(String message, UUID requestId) {
        this.activeRequest.setFailure(message, requestId);
    }

    @Override
    public void requestSuccessful(UUID requestId) {
        this.activeRequest.setSuccess(new Success(), requestId);
    }

    @Override
    public void runCollectionSuccessfullyScheduled(UUID requestId) {
        this.activeRequest.setSuccess(new Success(), requestId);
    }
}

