/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.network;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.client.network.ClientAPI;
import org.sosy_lab.verifiercloud.client.network.ClientAuthorizationState;
import org.sosy_lab.verifiercloud.client.network.ConnectionEventHandler;
import org.sosy_lab.verifiercloud.client.network.MasterAbstraction;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.Success;
import org.sosy_lab.verifiercloud.client.network.exceptions.AuthenticationFailedException;
import org.sosy_lab.verifiercloud.client.network.exceptions.FileNotAvailableOnTheMaster;
import org.sosy_lab.verifiercloud.client.network.exceptions.InsufficientRightsException;
import org.sosy_lab.verifiercloud.client.network.exceptions.MasterSummaryNotRetrievableException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RequestFailureException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RunCanceledException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RunSubmissionFailureException;
import org.sosy_lab.verifiercloud.client.network.results.ActiveRequests;
import org.sosy_lab.verifiercloud.client.network.results.ExceptionFactory;
import org.sosy_lab.verifiercloud.client.run_storage.ClientRunStorage;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.establishing.connection_builder.ConnectionBuilder;
import org.sosy_lab.verifiercloud.global.networking.establishing.connection_builder.ConnectionBuilderListener;
import org.sosy_lab.verifiercloud.global.networking.interaction.AsyncIncomingCommandHandler;
import org.sosy_lab.verifiercloud.global.networking.interaction.IncomingCommandHandler;
import org.sosy_lab.verifiercloud.master.clientside.ClientAccessLevel;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.AddRunCollectionCommand;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.AddWorkerCommand;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.AuthenticationCommand;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.ChangeRunCollectionPriorityCommand;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.ClientToMasterCommand;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.RemoveWorkerCommand;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.RequestMasterSummaryCommand;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.RequestResultFileCommand;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.RequestRunResultAsZipCommand;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.SendFileCommand;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.StopMasterCommand;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.StopRunCollectionCommand;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.master.MasterSummary;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.workerstart.WorkerStartInformation;

public class DefaultMasterConnection
implements MasterConnection,
ConnectionEventHandler {
    private static final String NO_MASTER_CONNECTION_ESTABLISHED = "No master connection established.";
    private final Logger logger;
    private final ConnectionBuilder conBuilder;
    private final ConnectionEventHandler conEventHandler;
    private final IncomingCommandHandler<ClientAPI> incQueue;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final ClientRunStorage clientRunStorage;
    private final ActiveRequests activeRequests;
    private volatile Optional<MasterAbstraction> optionalMaster = Optional.absent();
    private volatile ClientAuthorizationState clientAuthorizationState = ClientAuthorizationState.DISCONNECTED;
    private final AtomicBoolean currentAuthenticationProgress = new AtomicBoolean();
    private volatile Optional<SettableFuture<ClientAuthorizationState>> currentConnectionProgress = Optional.absent();
    private final AtomicBoolean active = new AtomicBoolean(true);
    private int receivedFiles = 0;
    private MemoryUnit receivedFilesSize = MemoryUnit.zero();
    private int sentFiles = 0;
    private MemoryUnit sentFilesSize = MemoryUnit.zero();

    @Inject
    public DefaultMasterConnection(ConnectionBuilder connectionBuilder, ClientRunStorage clientRunStorage, ClientAPI api, Logger logger, ActiveRequests activeRequest, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, ConnectionEventHandler conEventHandler) {
        this.logger = Preconditions.checkNotNull(logger);
        this.activeRequests = Preconditions.checkNotNull(activeRequest);
        this.conEventHandler = Preconditions.checkNotNull(conEventHandler);
        this.conBuilder = Preconditions.checkNotNull(connectionBuilder);
        this.uncaughtExceptionHandler = Preconditions.checkNotNull(uncaughtExceptionHandler);
        this.incQueue = new AsyncIncomingCommandHandler<ClientAPI>(api, uncaughtExceptionHandler, logger);
        this.clientRunStorage = Preconditions.checkNotNull(clientRunStorage);
    }

    @Override
    public ListenableFuture<ClientAuthorizationState> connect() {
        SettableFuture<ClientAuthorizationState> connectionState = SettableFuture.create();
        this.currentConnectionProgress = Optional.of(connectionState);
        this.conBuilder.connect(new ClientConnectionAcceptor());
        this.incQueue.start();
        return connectionState;
    }

    @Override
    public void disconnectAndDisable() {
        if (this.optionalMaster.isPresent()) {
            this.active.set(false);
            this.optionalMaster.get().terminateCommunication();
        }
        this.incQueue.stop();
    }

    @Override
    public String getMasterHostName() {
        return this.conBuilder.getMasterHostName();
    }

    @Override
    public boolean isConnected() {
        return this.active.get() && this.optionalMaster.isPresent();
    }

    @Override
    public ClientAuthorizationState getAuthorization() {
        return this.clientAuthorizationState;
    }

    @Override
    public CheckedFuture<ClientAuthorizationState, AuthenticationFailedException> authenticate(ClientAccessLevel desiredLevel, String username) {
        Preconditions.checkNotNull(username);
        Preconditions.checkState(this.isConnected(), "Not connected to Master.");
        Preconditions.checkState(!this.currentAuthenticationProgress.getAndSet(true), "The previous authentication process is not yet finished.");
        AuthenticationCommand command = new AuthenticationCommand(desiredLevel, username);
        CheckedFuture<ClientAccessLevel, AuthenticationFailedException> requestFuture = this.activeRequests.createRequestFuture(ClientAccessLevel.class, new ExceptionFactory<AuthenticationFailedException>(){

            @Override
            public AuthenticationFailedException createException(String message) {
                return new AuthenticationFailedException(message);
            }
        }, command.getRequestId());
        this.sendCommand(command);
        Futures.addCallback(requestFuture, new FutureCallback<ClientAccessLevel>(){

            @Override
            public void onSuccess(ClientAccessLevel result) {
                Preconditions.checkState(DefaultMasterConnection.this.currentAuthenticationProgress.getAndSet(false), "There is no authentication process.");
                DefaultMasterConnection.this.clientAuthorizationState = new ClientAccessLevelToClientAuthorizationState().apply(result);
            }

            @Override
            public void onFailure(Throwable t) {
                Preconditions.checkState(DefaultMasterConnection.this.currentAuthenticationProgress.getAndSet(false), "There is no authentication process.");
            }
        });
        return Futures.makeChecked(Futures.transform(requestFuture, new ClientAccessLevelToClientAuthorizationState()), new Function<Exception, AuthenticationFailedException>(){

            @Override
            public AuthenticationFailedException apply(Exception input) {
                if (input instanceof AuthenticationFailedException) {
                    return (AuthenticationFailedException)input;
                }
                return new AuthenticationFailedException(input.getMessage());
            }
        });
    }

    @Override
    public CheckedFuture<MasterSummary, MasterSummaryNotRetrievableException> getMasterSummary() {
        if (!this.optionalMaster.isPresent()) {
            return Futures.immediateFailedCheckedFuture(new MasterSummaryNotRetrievableException(NO_MASTER_CONNECTION_ESTABLISHED));
        }
        MasterAbstraction masterAbstraction = this.optionalMaster.get();
        RequestMasterSummaryCommand command = new RequestMasterSummaryCommand();
        masterAbstraction.sendCommand(command);
        CheckedFuture<MasterSummary, MasterSummaryNotRetrievableException> requestFuture = this.activeRequests.createRequestFuture(MasterSummary.class, new ExceptionFactory<MasterSummaryNotRetrievableException>(){

            @Override
            public MasterSummaryNotRetrievableException createException(String message) {
                return new MasterSummaryNotRetrievableException(message);
            }
        }, command.getRequestId());
        return requestFuture;
    }

    void sendCommand(ClientToMasterCommand clientToMasterCommand) {
        if (this.isConnected() && this.optionalMaster.isPresent()) {
            this.optionalMaster.get().sendCommand(clientToMasterCommand);
        }
    }

    @Override
    public List<CheckedFuture<RunResult, RunCanceledException>> sendRunCollection(RunCollection runCollection, boolean detachable) throws InsufficientRightsException {
        Preconditions.checkNotNull(runCollection);
        ClientAuthorizationState.checkAuthorizationLevel(ClientAuthorizationState.USER, this.getAuthorization());
        List<CheckedFuture<RunResult, RunCanceledException>> futureRunResults = this.clientRunStorage.addRunCollection(runCollection);
        AddRunCollectionCommand command = new AddRunCollectionCommand(runCollection, detachable);
        this.activeRequests.createRequestFuture(Success.class, new RequestFailureException.RequestFailureExceptionFactory(), command.getRequestId());
        this.sendCommand(command);
        return futureRunResults;
    }

    @Override
    public CheckedFuture<Success, RunSubmissionFailureException> submitRunCollection(RunCollection runCollection) {
        Preconditions.checkNotNull(runCollection);
        this.clientRunStorage.addRunCollection(runCollection);
        AddRunCollectionCommand command = new AddRunCollectionCommand(runCollection, true);
        CheckedFuture<Success, RunSubmissionFailureException> resultFuture = this.activeRequests.createRequestFuture(Success.class, new RunSubmissionFailureException.RunSubmissionFailureExceptionFactory(), command.getRequestId());
        this.sendCommand(command);
        return resultFuture;
    }

    @Override
    public void sendFile(FileContent fileContent) throws InsufficientRightsException {
        Preconditions.checkNotNull(fileContent);
        ++this.sentFiles;
        this.sentFilesSize = MemoryUnit.sum(this.sentFilesSize, fileContent.getFileSize());
        SendFileCommand command = new SendFileCommand(fileContent);
        this.sendCommand(command);
    }

    @Override
    public CheckedFuture<Success, RequestFailureException> stopMaster() {
        if (!this.optionalMaster.isPresent()) {
            return Futures.immediateFailedCheckedFuture(new RequestFailureException(NO_MASTER_CONNECTION_ESTABLISHED));
        }
        StopMasterCommand command = new StopMasterCommand();
        CheckedFuture<Success, RequestFailureException> requestFuture = this.activeRequests.createRequestFuture(Success.class, new ExceptionFactory<RequestFailureException>(){

            @Override
            public RequestFailureException createException(String message) {
                return new RequestFailureException(message);
            }
        }, command.getRequestId());
        this.sendCommand(command);
        return requestFuture;
    }

    @Override
    public void onConnectionLost() {
        if (this.optionalMaster.isPresent()) {
            this.active.set(false);
        }
        this.clientAuthorizationState = ClientAuthorizationState.DISCONNECTED;
        this.conEventHandler.onConnectionLost();
        this.activeRequests.setFailureToAll("Connection to master closed.");
        this.logger.logf(Level.INFO, "Sent %d file(s) (%s).", this.sentFiles, this.sentFilesSize.toString());
        this.logger.logf(Level.INFO, "Received %d file(s) (%s).", this.receivedFiles, this.receivedFilesSize.toString());
    }

    @Override
    public CheckedFuture<FileContent, FileNotAvailableOnTheMaster> getResultFile(final HashCode fileHash) {
        Preconditions.checkState(this.isConnected());
        Preconditions.checkNotNull(fileHash);
        RequestResultFileCommand command = new RequestResultFileCommand(fileHash);
        CheckedFuture<FileContent, FileNotAvailableOnTheMaster> requestFuture = this.activeRequests.createRequestFuture(FileContent.class, new ExceptionFactory<FileNotAvailableOnTheMaster>(){

            @Override
            public FileNotAvailableOnTheMaster createException(String message) {
                return new FileNotAvailableOnTheMaster(fileHash, message);
            }
        }, command.getRequestId());
        Futures.addCallback(requestFuture, new FutureCallback<FileContent>(){

            @Override
            public synchronized void onSuccess(FileContent file) {
                DefaultMasterConnection.this.receivedFiles++;
                DefaultMasterConnection.this.receivedFilesSize = MemoryUnit.sum(DefaultMasterConnection.this.receivedFilesSize, file.getFileSize());
            }

            @Override
            public void onFailure(Throwable t) {
                DefaultMasterConnection.this.logger.logf(Level.WARNING, t, "Result file request failed: %s.", t.getMessage());
            }
        });
        this.sendCommand(command);
        return requestFuture;
    }

    @Override
    public CheckedFuture<Success, RequestFailureException> addWorker(WorkerStartInformation workerStartInformation) {
        if (!this.optionalMaster.isPresent()) {
            return Futures.immediateFailedCheckedFuture(new RequestFailureException(NO_MASTER_CONNECTION_ESTABLISHED));
        }
        AddWorkerCommand command = new AddWorkerCommand(workerStartInformation);
        CheckedFuture<Success, RequestFailureException> requestFuture = this.activeRequests.createRequestFuture(Success.class, new RequestFailureException.RequestFailureExceptionFactory(), command.getRequestId());
        this.sendCommand(command);
        return requestFuture;
    }

    @Override
    public CheckedFuture<Success, RequestFailureException> removeWorker(String hostname) {
        Preconditions.checkState(this.isConnected());
        Preconditions.checkArgument(!Strings.isNullOrEmpty(hostname));
        RemoveWorkerCommand command = new RemoveWorkerCommand(hostname);
        CheckedFuture<Success, RequestFailureException> requestFuture = this.activeRequests.createRequestFuture(Success.class, new RequestFailureException.RequestFailureExceptionFactory(), command.getRequestId());
        this.sendCommand(command);
        return requestFuture;
    }

    @Override
    public CheckedFuture<Success, RequestFailureException> changeRunCollectionPriority(String runCollectionId, SchedulingPriority priority) {
        Preconditions.checkState(this.isConnected());
        Preconditions.checkArgument(!Strings.isNullOrEmpty(runCollectionId));
        ChangeRunCollectionPriorityCommand command = new ChangeRunCollectionPriorityCommand(runCollectionId, priority);
        CheckedFuture<Success, RequestFailureException> requestFuture = this.activeRequests.createRequestFuture(Success.class, new RequestFailureException.RequestFailureExceptionFactory(), command.getRequestId());
        this.sendCommand(command);
        return requestFuture;
    }

    @Override
    public CheckedFuture<Success, RequestFailureException> stopRunCollection(String runCollectionId) {
        Preconditions.checkState(this.isConnected());
        Preconditions.checkArgument(!Strings.isNullOrEmpty(runCollectionId));
        StopRunCollectionCommand command = new StopRunCollectionCommand(runCollectionId);
        CheckedFuture<Success, RequestFailureException> requestFuture = this.activeRequests.createRequestFuture(Success.class, new RequestFailureException.RequestFailureExceptionFactory(), command.getRequestId());
        this.sendCommand(command);
        return requestFuture;
    }

    @Override
    public CheckedFuture<FileContent, RequestFailureException> requestRunResultAsZip(String runId) {
        Preconditions.checkState(this.isConnected());
        Preconditions.checkArgument(!Strings.isNullOrEmpty(runId));
        RequestRunResultAsZipCommand command = new RequestRunResultAsZipCommand(runId);
        CheckedFuture<FileContent, RequestFailureException> requestFuture = this.activeRequests.createRequestFuture(FileContent.class, new RequestFailureException.RequestFailureExceptionFactory(), command.getRequestId());
        this.sendCommand(command);
        return requestFuture;
    }

    private class ClientAccessLevelToClientAuthorizationState
    implements Function<ClientAccessLevel, ClientAuthorizationState> {
        private ClientAccessLevelToClientAuthorizationState() {
        }

        @Override
        public ClientAuthorizationState apply(ClientAccessLevel level) {
            ClientAuthorizationState state;
            switch (level) {
                case ADMIN: {
                    state = ClientAuthorizationState.ADMIN;
                    DefaultMasterConnection.this.logger.logf(Level.INFO, "Authenticated with ADMIN privileges.", new Object[0]);
                    break;
                }
                case UNAUTHENTICATED: {
                    state = ClientAuthorizationState.UNAUTHORIZED;
                    DefaultMasterConnection.this.logger.logf(Level.INFO, "Authentication failed.", new Object[0]);
                    break;
                }
                case USER: {
                    state = ClientAuthorizationState.USER;
                    DefaultMasterConnection.this.logger.logf(Level.INFO, "Authenticated with USER privileges.", new Object[0]);
                    break;
                }
                default: {
                    throw new RuntimeException("unhandled enum case");
                }
            }
            return state;
        }
    }

    private class ClientConnectionAcceptor
    implements ConnectionBuilderListener {
        private ClientConnectionAcceptor() {
        }

        @Override
        public void acceptSocket(Socket socket) {
            Preconditions.checkState(DefaultMasterConnection.this.currentConnectionProgress.isPresent());
            SettableFuture future = (SettableFuture)DefaultMasterConnection.this.currentConnectionProgress.get();
            DefaultMasterConnection.this.currentConnectionProgress = Optional.absent();
            if (DefaultMasterConnection.this.active.get()) {
                MasterAbstraction master = new MasterAbstraction(socket, DefaultMasterConnection.this.incQueue, DefaultMasterConnection.this, DefaultMasterConnection.this.uncaughtExceptionHandler, DefaultMasterConnection.this.logger);
                master.startCommunication();
                DefaultMasterConnection.this.optionalMaster = Optional.of(master);
                DefaultMasterConnection.this.clientAuthorizationState = ClientAuthorizationState.UNAUTHORIZED;
                DefaultMasterConnection.this.logger.logf(Level.INFO, "Connected to master on %s.", socket.getInetAddress().getHostName());
                future.set(ClientAuthorizationState.UNAUTHORIZED);
            } else {
                DefaultMasterConnection.this.logger.logf(Level.WARNING, "Tried to connect disablet master connection.", new Object[0]);
                DefaultMasterConnection.this.disconnectAndDisable();
                DefaultMasterConnection.this.clientAuthorizationState = ClientAuthorizationState.DISCONNECTED;
                future.set(ClientAuthorizationState.DISCONNECTED);
            }
        }

        @Override
        public void connectionFailed(String host, int port, String message) {
            Preconditions.checkState(DefaultMasterConnection.this.currentConnectionProgress.isPresent());
            DefaultMasterConnection.this.logger.logf(Level.SEVERE, "Connection to master cannot be established: %s", message);
            DefaultMasterConnection.this.incQueue.stop();
            DefaultMasterConnection.this.conEventHandler.onConnectionLost();
            SettableFuture future = (SettableFuture)DefaultMasterConnection.this.currentConnectionProgress.get();
            DefaultMasterConnection.this.currentConnectionProgress = Optional.absent();
            future.set(ClientAuthorizationState.DISCONNECTED);
        }
    }
}

