/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.network;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.List;
import org.sosy_lab.verifiercloud.client.network.ClientAuthorizationState;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.Success;
import org.sosy_lab.verifiercloud.client.network.exceptions.AuthenticationFailedException;
import org.sosy_lab.verifiercloud.client.network.exceptions.FileNotAvailableOnTheMaster;
import org.sosy_lab.verifiercloud.client.network.exceptions.InsufficientRightsException;
import org.sosy_lab.verifiercloud.client.network.exceptions.MasterSummaryNotRetrievableException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RequestFailureException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RunCanceledException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RunSubmissionFailureException;
import org.sosy_lab.verifiercloud.global.logging.LoggerBuilder;
import org.sosy_lab.verifiercloud.master.clientside.ClientAccessLevel;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.filecontent.DefaultFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.EmptyFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.ZipFileContent;
import org.sosy_lab.verifiercloud.transportable.info.FileStorageInformation;
import org.sosy_lab.verifiercloud.transportable.info.master.ExternalWorkerState;
import org.sosy_lab.verifiercloud.transportable.info.master.MasterSummary;
import org.sosy_lab.verifiercloud.transportable.info.master.RunCollectionSummary;
import org.sosy_lab.verifiercloud.transportable.info.master.SchedulerSummary;
import org.sosy_lab.verifiercloud.transportable.info.master.WorkerSummary;
import org.sosy_lab.verifiercloud.transportable.info.worker.ExecutorState;
import org.sosy_lab.verifiercloud.transportable.info.worker.LoadData;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionInformation;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionState;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerRuntimeInformation;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerState;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerStatistic;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.DummyHostInformation;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.LimitationsBuilder;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.MinimalRequirements;
import org.sosy_lab.verifiercloud.transportable.units.energy.Energy;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;
import org.sosy_lab.verifiercloud.transportable.workerstart.WorkerStartInformation;

public class DummyMasterConnection
implements MasterConnection {
    private volatile boolean connected = false;
    private int runCollectionSubmissionCounter = 0;
    private int resultAsZipRequestCounter = 0;
    private final List<FileAtRelativePath> resultFiles;
    private final boolean wasKilled;
    private final boolean error;
    private RunResult runResult;

    public DummyMasterConnection() {
        this.resultFiles = Lists.newArrayList();
        this.wasKilled = false;
        this.error = false;
    }

    public DummyMasterConnection(List<FileAtRelativePath> resultFiles, boolean wasKilled, boolean error) {
        this.resultFiles = Preconditions.checkNotNull(resultFiles);
        this.wasKilled = wasKilled;
        this.error = error;
    }

    @Override
    public ListenableFuture<ClientAuthorizationState> connect() {
        SettableFuture<ClientAuthorizationState> result = SettableFuture.create();
        result.set(ClientAuthorizationState.USER);
        this.connected = true;
        return result;
    }

    @Override
    public void disconnectAndDisable() {
        this.connected = false;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public String getMasterHostName() {
        return "masterHostName";
    }

    @Override
    public ClientAuthorizationState getAuthorization() {
        return null;
    }

    @Override
    public CheckedFuture<ClientAuthorizationState, AuthenticationFailedException> authenticate(ClientAccessLevel desiredLevel, String username) {
        return Futures.immediateCheckedFuture(ClientAuthorizationState.USER);
    }

    @Override
    public List<CheckedFuture<RunResult, RunCanceledException>> sendRunCollection(RunCollection runCollection, boolean detachable) throws InsufficientRightsException {
        ++this.runCollectionSubmissionCounter;
        this.setRunResult(runCollection);
        return ImmutableList.of(Futures.immediateCheckedFuture(this.runResult));
    }

    @Override
    public CheckedFuture<Success, RunSubmissionFailureException> submitRunCollection(RunCollection runCollection) {
        ++this.runCollectionSubmissionCounter;
        this.setRunResult(runCollection);
        return Futures.immediateCheckedFuture(new Success());
    }

    private void setRunResult(RunCollection runCollection) {
        Run run = (Run)runCollection.getRuns().get(0);
        this.runResult = new RunResult(run, this.wasKilled || this.error ? 1 : 0, TimeInterval.minutes(3L), TimeInterval.minutes(3L), ImmutableMap.of(), this.error ? DefaultFileContent.fromString("stdErr") : new EmptyFileContent(), this.resultFiles, this.resultFiles, Optional.of(Energy.kiloJoule(3L)), new DummyHostInformation(), this.wasKilled);
    }

    public int getRunCollectionSubmissionCounter() {
        return this.runCollectionSubmissionCounter;
    }

    @Override
    public void sendFile(FileContent fileContent) throws InsufficientRightsException {
    }

    @Override
    public CheckedFuture<FileContent, FileNotAvailableOnTheMaster> getResultFile(HashCode fileHash) {
        return Futures.immediateCheckedFuture(new EmptyFileContent());
    }

    @Override
    public CheckedFuture<MasterSummary, MasterSummaryNotRetrievableException> getMasterSummary() {
        MasterSummary masterSummary = new MasterSummary(TimeInterval.hours(2L), 3, new LoadData(2.0f, 3.0f, 5.0f), Lists.newArrayList(new WorkerSummary(ExternalWorkerState.AVAILABLE, Optional.of("testWorker"), new ExecutorState(Lists.newArrayList(new WorkerPartitionInformation(0, WorkerPartitionState.INITIALIZING, ImmutableMap.of(0, MemoryUnit.bytes(1L)), 1, "rc_id"))), new DummyHostInformation(), new WorkerRuntimeInformation(WorkerState.AVAILABLE, MemoryUnit.bytes(1L), MemoryUnit.bytes(1L), new LoadData(2.0f, 3.0f, 5.0f), MemoryUnit.bytes(1L), ImmutableMap.of(0, MemoryUnit.bytes(1L)), TimeInterval.seconds(1L), false, Lists.newArrayList(), Lists.newArrayList(), new FileStorageInformation(19, MemoryUnit.kilobyte(17L), MemoryUnit.gigabyte(42L)), ImmutableSet.of(), MemoryUnit.gigabyte(1L), new WorkerStatistic(0.5, 0.5, 0.5, new LoadData(2.0f, 3.0f, 5.0f))), MemoryUnit.zero(), 0)), Lists.newArrayList("TestWorker"), new SchedulerSummary(ImmutableList.of(new RunCollectionSummary("id", "name", 1, 0, "testuser", 1L, TimeInterval.seconds(1L), MinimalRequirements.getInstance().toScheduledRequirements(ImmutableList.of(), LoggerBuilder.create().build()), ImmutableSet.of(LimitationsBuilder.from(TimeInterval.seconds(1L)).build()), SchedulingPriority.IDLE, true)), 0, 0, 0, TimeInterval.milliseconds(131L), TimeInterval.milliseconds(1L)), new FileStorageInformation(19, MemoryUnit.kilobyte(17L), MemoryUnit.gigabyte(42L)));
        return Futures.immediateCheckedFuture(masterSummary);
    }

    @Override
    public CheckedFuture<Success, RequestFailureException> stopMaster() {
        return null;
    }

    @Override
    public CheckedFuture<Success, RequestFailureException> addWorker(WorkerStartInformation workerStartInformation) {
        return null;
    }

    @Override
    public CheckedFuture<Success, RequestFailureException> removeWorker(String hostname) {
        return null;
    }

    @Override
    public CheckedFuture<Success, RequestFailureException> changeRunCollectionPriority(String runCollectionId, SchedulingPriority priority) {
        return null;
    }

    @Override
    public CheckedFuture<Success, RequestFailureException> stopRunCollection(String runCollectionId) {
        return null;
    }

    @Override
    public CheckedFuture<FileContent, RequestFailureException> requestRunResultAsZip(String runId) {
        ZipFileContent fileContent;
        ++this.resultAsZipRequestCounter;
        try {
            fileContent = ZipFileContent.fromString("testContent42");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Futures.immediateCheckedFuture(fileContent);
    }

    public int getResultAsZipRequestCounter() {
        return this.resultAsZipRequestCounter;
    }
}

