/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.network;

import com.google.common.base.Preconditions;
import java.net.Socket;
import org.sosy_lab.verifiercloud.client.network.ClientAPI;
import org.sosy_lab.verifiercloud.client.network.ConnectionEventHandler;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.interaction.ConnectionListener;
import org.sosy_lab.verifiercloud.global.networking.interaction.IncomingCommandHandler;
import org.sosy_lab.verifiercloud.global.networking.interaction.NetworkAbstraction;
import org.sosy_lab.verifiercloud.master.clientside.ClientAccessLevel;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.AuthenticationCommand;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.ClientToMasterCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.MasterToClientCommand;

public class MasterAbstraction
extends NetworkAbstraction<MasterToClientCommand, ClientToMasterCommand, ClientAPI> {
    private final IncomingCommandHandler<ClientAPI> incomingCommandHandler;
    private final ConnectionEventHandler abstractionListener;

    public MasterAbstraction(Socket socketToMaster, IncomingCommandHandler<ClientAPI> incQueue, ConnectionEventHandler abstractionListener, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Logger logger) {
        super(socketToMaster, uncaughtExceptionHandler, logger, MasterToClientCommand.class);
        this.incomingCommandHandler = Preconditions.checkNotNull(incQueue);
        this.abstractionListener = abstractionListener;
        this.addConnectionListener(new MasterConnectionListener());
    }

    void authenticate(ClientAccessLevel desiredLevel, String username) {
        Preconditions.checkNotNull(username);
        this.sendCommand(new AuthenticationCommand(desiredLevel, username));
    }

    private class MasterConnectionListener
    implements ConnectionListener<MasterToClientCommand> {
        private MasterConnectionListener() {
        }

        @Override
        public void connectionClosed() {
            MasterAbstraction.this.abstractionListener.onConnectionLost();
        }

        @Override
        public void messageReceived(MasterToClientCommand message) {
            MasterAbstraction.this.incomingCommandHandler.addCommand(MasterAbstraction.this, message);
        }
    }
}

