/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.network;

import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.sosy_lab.verifiercloud.client.network.ClientAuthorizationState;
import org.sosy_lab.verifiercloud.client.network.Success;
import org.sosy_lab.verifiercloud.client.network.exceptions.AuthenticationFailedException;
import org.sosy_lab.verifiercloud.client.network.exceptions.FileNotAvailableOnTheMaster;
import org.sosy_lab.verifiercloud.client.network.exceptions.InsufficientRightsException;
import org.sosy_lab.verifiercloud.client.network.exceptions.MasterSummaryNotRetrievableException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RequestFailureException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RunCanceledException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RunSubmissionFailureException;
import org.sosy_lab.verifiercloud.master.clientside.ClientAccessLevel;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.master.MasterSummary;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;
import org.sosy_lab.verifiercloud.transportable.workerstart.WorkerStartInformation;

public interface MasterConnection {
    public ListenableFuture<ClientAuthorizationState> connect();

    public void disconnectAndDisable();

    public boolean isConnected();

    public String getMasterHostName();

    public ClientAuthorizationState getAuthorization();

    public CheckedFuture<ClientAuthorizationState, AuthenticationFailedException> authenticate(ClientAccessLevel var1, String var2);

    public List<CheckedFuture<RunResult, RunCanceledException>> sendRunCollection(RunCollection var1, boolean var2) throws InsufficientRightsException;

    public CheckedFuture<Success, RunSubmissionFailureException> submitRunCollection(RunCollection var1);

    public void sendFile(FileContent var1) throws InsufficientRightsException;

    public CheckedFuture<FileContent, FileNotAvailableOnTheMaster> getResultFile(HashCode var1);

    public CheckedFuture<MasterSummary, MasterSummaryNotRetrievableException> getMasterSummary();

    public CheckedFuture<Success, RequestFailureException> stopMaster();

    public CheckedFuture<Success, RequestFailureException> addWorker(WorkerStartInformation var1);

    public CheckedFuture<Success, RequestFailureException> removeWorker(String var1);

    public CheckedFuture<Success, RequestFailureException> changeRunCollectionPriority(String var1, SchedulingPriority var2);

    public CheckedFuture<Success, RequestFailureException> stopRunCollection(String var1);

    public CheckedFuture<FileContent, RequestFailureException> requestRunResultAsZip(String var1);
}

