/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.network.results;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.sosy_lab.verifiercloud.client.network.exceptions.MasterCommunicationException;
import org.sosy_lab.verifiercloud.client.network.results.ExceptionFactory;
import org.sosy_lab.verifiercloud.client.network.results.RequestException;

public class ActiveRequests {
    private volatile Map<UUID, SettableFuture<?>> currentInteractions = Maps.newHashMap();
    private volatile Map<UUID, Class<?>> successTypes = Maps.newHashMap();

    public synchronized <S, F extends MasterCommunicationException> CheckedFuture<S, F> createRequestFuture(Class<S> typeOfSuccessObject, final ExceptionFactory<F> exceptionFactory, UUID requestId) {
        this.checkClassInvariant(requestId);
        Preconditions.checkArgument(!typeOfSuccessObject.isPrimitive(), "Variable must not be of primitive type.");
        SettableFuture future = SettableFuture.create();
        this.currentInteractions.put(requestId, future);
        this.successTypes.put(requestId, typeOfSuccessObject);
        return Futures.makeChecked(future, new Function<Exception, F>(){

            @Override
            @Nullable
            public F apply(Exception input) {
                Preconditions.checkNotNull(input);
                return exceptionFactory.createException(input.getMessage());
            }
        });
    }

    public synchronized <S> void setSuccess(S successObject, UUID requestId) throws RequestException {
        this.checkClassInvariant(requestId);
        if (!this.currentInteractions.containsKey(requestId)) {
            throw new RequestException("No active interaction.");
        }
        if (!this.successTypes.get(requestId).isInstance(successObject)) {
            throw new RequestException(String.format("%s is not instance of %s", successObject.getClass().getSimpleName(), this.successTypes.get(requestId).getSimpleName()));
        }
        SettableFuture<?> correctlyTypedFuture = this.currentInteractions.get(requestId);
        this.clear(requestId);
        correctlyTypedFuture.set(successObject);
    }

    public synchronized void setFailure(final String message, UUID requestId) {
        this.checkClassInvariant(requestId);
        Preconditions.checkState(this.currentInteractions.containsKey(requestId));
        SettableFuture<?> untypedFuture = this.currentInteractions.get(requestId);
        this.clear(requestId);
        untypedFuture.setException(new Exception(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getMessage() {
                return message;
            }
        });
    }

    public synchronized void setFailureToAll(String message) {
        for (UUID requestId : ImmutableMap.copyOf(this.currentInteractions).keySet()) {
            this.setFailure(message, requestId);
        }
    }

    public synchronized boolean hasRequestPending(UUID requestId) {
        this.checkClassInvariant(requestId);
        return this.currentInteractions.containsKey(requestId);
    }

    private void clear(UUID requestId) {
        this.currentInteractions.remove(requestId);
        this.successTypes.remove(requestId);
    }

    private void checkClassInvariant(UUID requestId) {
        Preconditions.checkState(this.currentInteractions.containsKey(requestId) && this.successTypes.containsKey(requestId) || !this.currentInteractions.containsKey(requestId) && !this.successTypes.containsKey(requestId));
    }
}

